
#include <avr/io.h>
#include <avr/boot.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include "types.h"
#include "control.h"
#include "uart.h"
#include "cmd_table.h"
#include "defs.h"




void writeFlashPage();
void readPage();
void eraseChip();


u16 addr;
u8 prog_mode;

#define LED0 PORTC = 0
#define LED1 PORTC = 1
u8 rx_buff[PAGE_SIZE];

int main(){
	
	u8 cmd;
	DDRA = 0;
	DDRB = 0;
	DDRC = 0;
	DDRD = 0;
	PORTA = 0;
	PORTB = 0;
	PORTC = 0;
	PORTD = 0;
	PORTA = (1 << 7);
	DDRC |= 1;
	EXIT_BOOT_IF_RESET;
	cli();
	
	uartInit();
	prog_mode = 0;
	
	for(;;){
	
		
		LED0;
		cmd = uartRX();
		if(cmd != CMD_NEW)continue;
		cmd = uartRX();
		LED1;

		switch(cmd){
			
			case CMD_BOOT_EXIT_BOOT:
				boot_rww_enable ();
				EXIT_BOOT;
				break;

			case CMD_TEST:

				uartTX(CMD_OK);
				break;

			case CMD_SET_ADDR:

				addr = uartRX32();
				uartTX(CMD_OK);
				break;
		
			case CMD_BOOT_READ_PAGE:

				uartTX(CMD_OK);
				readPage();
				break;

		
			case CMD_BOOT_ERASE:

				if(prog_mode){
					eraseChip();
					uartTX(CMD_OK);
				}else{
					uartTX('?');
				}
				break;

		
			case CMD_BOOT_WRITE_PAGE:

				if(prog_mode){
					writeFlashPage();
				}else{
					uartTX('?');
				}
				break;


			case CMD_BOOT_ENTER_PROG_MODE:

				prog_mode = 1;
				uartTX(CMD_OK);
				break;

		
			case CMD_BOOT_EXIT_PROG_MODE:

				prog_mode = 0;
				uartTX(CMD_OK);
				break;

			case CMD_FIRM_VERSION:
				uartTX(CMD_OK);
				uartTX16(BOOT_VERSION);
				break;

			case CMD_BOOT_APP_END:
				uartTX(CMD_OK);
				uartTX16(APP_END);
				break;

			case CMD_BOOT_PAGE_SIZE:
				uartTX(CMD_OK);
				uartTX16(PAGE_SIZE);
				break;			

			default:

				uartTX('?');
		
		}
		

	}


	return 0;	
}



void writeFlashPage(){
	

	if(addr > APP_END){
		uartTX('?');
		return;
	}

	u16 i;
	

	for(i = 0;i < PAGE_SIZE;i++){
		
		rx_buff[i] = uartRX();
	}


	for(i = 0;i < PAGE_SIZE; i+= 2){

		boot_page_fill(addr + i, rx_buff[i + 1] << 8 | rx_buff[i]);
	}

	boot_page_write (addr);
    boot_spm_busy_wait();
	boot_rww_enable ();

	addr += PAGE_SIZE;

	uartTX(CMD_OK);
	
	
}

void readPage(){
	
	u8 data;
	boot_spm_busy_wait();
	boot_rww_enable();
	u16 i;
	for(i = 0;i < PAGE_SIZE;i++){
		data = pgm_read_byte_near(addr);
		addr++;
		uartTX(data);
	}
}


void eraseChip(){
	
	u16 i;
	boot_spm_busy_wait();
	for(i = 0;i < APP_END;i += PAGE_SIZE){
		
		boot_page_erase(i);
		boot_spm_busy_wait();
	}
}


