﻿using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using ICSharpCode.SharpZipLib.Zip;
using ICSharpCode.SharpZipLib.Zip.Compression.Streams;


namespace everdrive3x.Misc
{
    class ZipFile
    {
        public static byte[] load(String filename)
        {
            FileStream f = File.OpenRead(filename);
            byte[] buff = null;

            ZipInputStream zis = new ZipInputStream(f);
            ZipEntry entry = null;

            for (int i = 0; i < 10; i++)
            {
                try
                {
                    entry = zis.GetNextEntry();
                }
                catch (Exception)
                {
                    break;
                }


                if (!entry.ToString().Contains(".bin") &&
                    !entry.ToString().Contains(".smd") &&
                    !entry.ToString().Contains(".gen") &&
                    !entry.ToString().Contains(".smc") &&
                    !entry.ToString().Contains(".v64") &&
                    !entry.ToString().Contains(".z64") &&
                    !entry.ToString().Contains(".rom"))
                {
                    continue;
                }
                if (zis.Length > 8388608 * 8)
                {
                    continue;
                }
                buff = new byte[zis.Length];
                zis.Read(buff, 0, buff.Length);
                zis.Close();
                f.Close();
                return buff;
            }

            throw new Exception("zip: rom not found");

        }

        public static bool isZip(String filename)
        {
            FileStream file = File.OpenRead(filename);
            if (file.ReadByte() == 0x50 && file.ReadByte() == 0x4B && file.ReadByte() == 0x03 && file.ReadByte() == 0x04)
            {
                file.Close();
                return true;
            }
            file.Close();
            return false;
        }
    }
}
