﻿using System;
using System.Collections.Generic;
using System.Text;
using everdrive3x.Hardware;
using everdrive3x.Misc;
using System.IO;

namespace everdrive3x.Rom
{
    class RomTools
    {
      

        public static String getRomExtension(Device device)
        {
            switch (device.Profile.PlatformID)
            {
                case PlatformList.ID_SEGA:
                    return "bin";
                case PlatformList.ID_N64:
                    return "z64";
                default:
                    return "dat";
            }
        }

        public static RomInterface loadrRom(String file_name)
        {
            RomInterface rom = null;
            byte[] buff = null;

            if (ZipFile.isZip(file_name))
            {
                buff = ZipFile.load(file_name);
            }
            else
            {
                FileStream file = File.OpenRead(file_name);
                buff = new byte[Math.Max(65536, file.Length)];
                file.Read(buff, 0, (int)file.Length);
                file.Close();
            }
            if (N64Rom.getRomType(buff, 0) != null)
            {
                rom = new N64Rom(buff, 0, buff.Length);
            }
            else
            {
                rom = new SegaRom(buff, 0, buff.Length);
            }
            return rom;
        }


        
    }
}
