/* 
 * File:   main.c
 * Author: KRIK
 *
 * Created on 24  2009 ., 5:20
 */

#include "genesis.h"


#define MAX_STR_LEN 32
#define PAGE_SIZE 16
#define LIST_Y 8
#define LIST_X 2


u16 selected_game;
s8 game_selector;
s8 page_selector;
u8 page_size;
u8 total_games;
u8 total_pages;


void startGame();
void cleanHardware();
void initLoader();
void selectPage(u8 page);


u8 *header_ptr;
const u8 def_reg_state[] = {
    0x04, 0x04, 0x30, 0x2c, 0x07, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x81, 0x2b, 0x00, 0x02, 0x01, 0x00, 0x00, 0xff, 0xff
};

int main() {


    u16 joy;
    VDP_drawText(APLAN, "  ************************************", 0, 0, 0);
    VDP_drawText(APLAN, "  *                                  *", 0, 0, 1);
    VDP_drawText(APLAN, "  *        SEGA game loader v1.0     *", 0, 0, 2);
    VDP_drawText(APLAN, "  *          http://krikzz.com       *", 0, 0, 3);
    VDP_drawText(APLAN, "  *                                  *", 0, 0, 4);
    VDP_drawText(APLAN, "  ************************************", 0, 0, 5);

    initLoader();
    selectPage(0);
    VDP_drawText(APLAN, ">", 0, LIST_X, LIST_Y + game_selector);
    VDP_setPalette(0, palette_grey);

    for (;;) {

        joy = JOY_readJoypad(JOY_1);

        if ((joy & BUTTON_UP)) {
            VDP_setTile(APLAN, 0, LIST_X, LIST_Y + game_selector);
            game_selector--;
            if (game_selector < 0)game_selector = page_size - 1;
            VDP_drawText(APLAN, ">", 0, LIST_X, LIST_Y + game_selector);
            while ((JOY_readJoypad(JOY_1) & BUTTON_UP));
        }
        if ((joy & BUTTON_DOWN)) {
            VDP_setTile(APLAN, 0, LIST_X, LIST_Y + game_selector);
            game_selector++;
            if (game_selector >= page_size)game_selector = 0;
            VDP_drawText(APLAN, ">", 0, LIST_X, LIST_Y + game_selector);
            while ((JOY_readJoypad(JOY_1) & BUTTON_DOWN));
        }

        if ((joy & BUTTON_START)) {

            selected_game = page_selector * PAGE_SIZE + game_selector + 1;
            cleanHardware();
            startGame();
            while ((JOY_readJoypad(JOY_1) & BUTTON_START));
        }

    }

    return 0;

}

void gameLoaderStart() {


    cleanHardware();
    VDP_init();
    PSG_init();
    JOY_init();
    VDP_setPalette(0, palette_black);

    main();
}

void cleanHardware() {

    u16 i;
    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
    YM2612_reset();
    Z80_startReset();
    for (i = 0; i < sizeof (def_reg_state); i++) {
        VDP_setReg(i, def_reg_state[i]);
    }

}

void initLoader() {

    u8 i;
    header_ptr = (u8 *) 65536;

    selected_game = 0;
    game_selector = 0;
    page_selector = 0;

    for (i = 0; i < 32; i++) {

        if (header_ptr[i * MAX_STR_LEN] == 0) {
            break;
        }
        total_games++;
    }
    if (total_games == 0)total_games = 1;

}

void selectPage(u8 page) {

    u16 i;
    u8 offset = page * PAGE_SIZE;
    page_size = total_games - offset;
    if (page_size > PAGE_SIZE)page_size = PAGE_SIZE;
    for (i = 0; i < page_size; i++) {

        VDP_drawText(APLAN, &header_ptr[offset * MAX_STR_LEN + i * MAX_STR_LEN], 0, LIST_X + 1, LIST_Y + i);
    }

    page_selector = page;
}

