﻿using System;
using System.Collections.Generic;
using System.Text;
using everdrive3x.Hardware;

namespace everdrive3x.Rom
{
    class RomHeader
    {
        public static RomInterface getHeader(Device device)
        {

            return getSegaHeader(device);
        }

        static RomInterface getSegaHeader(Device device)
        {
            byte[] header = new byte[1024];
            device.Control.setAddr(0);
            device.Control.resetByPass();
            for (int i = 0; i < 8; i++)
            {
                System.Array.Copy(device.Control.readBlock(128), 0, header, i * 128, 128);
            }
            if (N64Rom.getRomType(header, 0) != null)
            {
                return new N64Rom(header, 0, header.Length);
            }
            else
            {
                return new SegaRom(header, 0, header.Length);
            }

        }
    }

}
