﻿using System;
using System.Collections.Generic;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using everdrive3x.GG;

namespace everdrive3x
{
    public partial class Cheats : Form
    {
        
        bool change_lock;
        GGInterface gg_engine;
 
        public Cheats()
        {
            InitializeComponent();
            change_lock = false;
            checkBox_clean_after_write.Checked = true;
            gg_engine = new SegaGG();
        }

        private void textBox_gg_code_TextChanged(object sender, EventArgs e)
        {
            if (change_lock) return;
            change_lock = true;
            String str = gg_engine.fixGGString(textBox_gg_code.Text);

            textBox_gg_code.Text = "";
            textBox_gg_code.AppendText(str);
            textBox_hex_code.Text = gg_engine.GGToHexStr(str);
            change_lock = false;
            
        }

        private void textBox_hex_code_TextChanged(object sender, EventArgs e)
        {
            if (change_lock) return;
            change_lock = true;

            String str = gg_engine.fixHexString(textBox_hex_code.Text);
            textBox_hex_code.Text = "";
            textBox_hex_code.AppendText(str);
            textBox_gg_code.Text = gg_engine.hexToGGStr(str);
            change_lock = false;
        }

        private void button_add_Click(object sender, EventArgs e)
        {
            if (textBox_gg_code.Text.Length == 9 && textBox_hex_code.Text.Length == 11)
            {
                listBox_code_list.Items.Add(textBox_gg_code.Text + " - " + textBox_hex_code.Text);
            }
        }

        private void button_remove_Click(object sender, EventArgs e)
        {
            listBox_code_list.Items.Remove(listBox_code_list.SelectedItem);
        }

        public String[] getCods()
        {
            int i = 0;
            String[] codes = new String[listBox_code_list.Items.Count];
            IEnumerator e = listBox_code_list.Items.GetEnumerator();

            while (e.MoveNext())
            {
                codes[i++] = e.Current.ToString();
            }

            return codes;
        }

        public Object GGEngine
        {
            get { return gg_engine; }
        }


        public void cleanIfNeed()
        {
            if (checkBox_clean_after_write.Checked)
            {
                listBox_code_list.Items.Clear();
            }
        }


        private void Cheats_FormClosed(object sender, FormClosedEventArgs e)
        {
            change_lock = true;
            textBox_gg_code.Text = "";
            textBox_hex_code.Text = "";
            change_lock = false;
        }

        private void button_ok_Click(object sender, EventArgs e)
        {
            this.Close();
        }
     
    }
}
