﻿using System;
using System.Collections.Generic;
using System.Text;
using everdrive3x.Misc;

namespace everdrive3x.GG
{
    class SegaGG : GGInterface
    {
        static char[] gg_chars = "ABCDEFGHJKLMNPRSTVWXYZ0123456789".ToCharArray();
        static char[] sort_table_a = "ijklmnopIJKLMNOPABCDEFGHdefghabcQRSTUVWX".ToCharArray();
        static char[] sort_table_b = "ABCDEFGHIJKLMNOPQRSTUVWXabcdefghijklmnop".ToCharArray();
        static byte[] sort_table;

        public SegaGG()
        {
            sort_table = new byte[40];
            for (int i = 0; i < 40; i++)
            {
                for (int u = 0; u < 40; u++)
                {
                    if (sort_table_a[i] == sort_table_b[u]) sort_table[i] = (byte)u;
                }
            }
        }

        public String fixGGString(String src_str)
        {

            char[] code = src_str.ToUpper().ToCharArray();
            String str = "";

            for (int i = 0; i < code.Length; i++)
            {
                if (isGGChar(code[i]))
                {
                    str += code[i];
                }
            }

            str = str.Substring(0, Math.Min(8, str.Length));

            if (str.Length > 4) str = str.Substring(0, 4) + "-" + str.Substring(4, str.Length - 4);
            GGToInt(str);
            return str;

        }

        public String fixHexString(String src)
        {
            String str = "";


            for (int i = 0; i < src.Length; i++)
            {
                char ch = src.ToUpper().ToCharArray()[i];
                if ((ch >= '0' && ch <= '9') || (ch >= 'A' && ch <= 'F')) str += ch;
            }

            str = str.Substring(0, Math.Min(10, str.Length));
            if (str.Length > 6) str = str.Substring(0, 6) + ":" + str.Substring(6, str.Length - 6);

            return str;
        }
        public String GGToHexStr(String src)
        {
            String str = "";
            UInt64 hex = GGToInt(src);
            for (int i = 0; i < 3; i++) str += DataTool.byteToHex((int)(hex >> 32 - i * 8));
            str += ":";
            for (int i = 3; i < 5; i++) str += DataTool.byteToHex((int)(hex >> 32 - i * 8));
            return str;
        }
        public String hexToGGStr(String src)
        {
            String str = "";
            UInt64 val = hexToInt(src);


            UInt64 sorted_val = sortHexToGG(val);

            for (int i = 0; i < 8; i++)
            {
                str += gg_chars[(sorted_val >> (35 - i * 5)) & 31];
            }

            return fixGGString(str);
        }



        public void applyGGCode(String code, byte[] rom)
        {
            String code_str = fixGGString(code);
            int addr = addrFromGG(code_str);
            int data = dataFromGG(code_str);
            if (addr >= rom.Length)
            {
                throw new Exception("address ouf of ROM bound");
            }
            rom[addr + 0] = (byte)(data >> 8);
            rom[addr + 1] = (byte)(data & 0xff);
        }

        //*** internal functions
        bool isGGChar(char ch)
        {
            for (int i = 0; i < gg_chars.Length; i++)
            {
                if (gg_chars[i] == ch) return true;
            }
            return false;
        }

        UInt32 GGCharToInt(char ch)
        {
            for (UInt32 i = 0; i < gg_chars.Length; i++)
            {
                if (ch == gg_chars[i]) return i;
            }
            return 0;
        }

        UInt64 sortGGToHex(UInt64 val)
        {
            UInt64 sorted_val = 0;
            for (int i = 0; i < 40; i++)
            {
                UInt64 bit = (val >> (39 - i)) & 1;
                sorted_val |= bit << (39 - sort_table[i]);
            }

            return sorted_val;
        }

        UInt64 sortHexToGG(UInt64 val)
        {
            UInt64 sorted_val = 0;
            for (int i = 0; i < 40; i++)
            {
                UInt64 bit = val >> (39 - sort_table[i]) & 1;
                sorted_val |= bit << (39 - i);
            }

            return sorted_val;
        }

        int addrFromGG(String gg)
        {
            gg = fixGGString(gg);
            UInt64 addr = GGToInt(gg);
            addr >>= 16;
            return (int)addr;
        }

        int dataFromGG(String gg)
        {
            gg = fixGGString(gg);
            UInt64 data = GGToInt(gg);
            return (int)(data & 0xFFFF);
        }

        UInt64 GGToInt(String gg)
        {
            UInt64 val = 0;
            if (gg.Length < 9) return 0;
            char[] val_chars = (gg.Substring(0, 4) + gg.Substring(5, 4)).ToCharArray();

            for (int i = 0; i < 8; i++)
            {
                val <<= 5;
                char ch = gg.ToCharArray()[i];
                val |= GGCharToInt(val_chars[i]);

            }

            return sortGGToHex(val);
        }

        UInt64 hexToInt(String hex)
        {

            if (hex.Length < 11) return 0;
            String str = hex.Substring(0, 6) + hex.Substring(7, 4);
            return Convert.ToUInt64(str, 16);

        }
    }
}
