﻿using System;
using System.Collections.Generic;
using System.Text;

namespace everdrive3x.Rom
{
    class SmsRom : RomInterface
    {
        public const String ROM_TYPE_SMS = "SMS";
        const byte SELECT_MODE_RESET = 1;
        const byte SELECT_MODE_LOADER = 2;
        const byte SELECT_MODE_NO = 0xff;

        byte[] bin_data;
        byte[] config;
        String rom_type;
        String rom_name;
        int declarated_size;
        String platform;
        static int header_len;

        public SmsRom(byte[] src, int offset, int len)
        {
            rom_type = getRomType(src, offset, len);

            if (rom_type == null)
            {
                throw new Exception("non SMS rom format");
            }

            loadSms(src, header_len, src.Length - header_len);

        }


        void loadSms(byte[] src, int offset, int len)
        {
             

            config = new byte[0];
            //config[0] = (byte)SELECT_MODE_NO;

            if (len % 256 != 0)
            {
                bin_data = new byte[len + len % 256];
            }
            else
            {
                bin_data = new byte[len];
            }
            System.Array.Copy(src, offset, bin_data, 0, len);
            rom_name = "?";
            declarated_size = bin_data.Length;
            declarated_size &= ~1;
            platform = Hardware.PlatformList.NAME_SMS;
        }     
       

        
        public static String getRomType(byte[] src, int offset, int len)
        {
            header_len = 0;
            try
            {
                bool head = true;
                char []header = "TMR SEGA".ToCharArray();
                for (int i = 0; i < header.Length; i++)
                {
                    if ((byte)header[i] != src[i + 32768 - 16])
                    {
                        head = false;
                        break;
                    }
                }

                if (head) return ROM_TYPE_SMS;

                head = true;

                for (int i = 0; i < header.Length; i++)
                {
                    if ((byte)header[i] != src[i + 32768 - 16 + 512])
                    {
                        head = false;
                        break;
                    }
                }
                header_len = 512;
                if (head) return ROM_TYPE_SMS;
            }
            catch (Exception) { }


            return null;
        }

        public byte[] BinData
        {
            get { return bin_data; }
        }

        public byte[] Config
        {
            get { return config; }
        }

        public String Name
        {
            get { return rom_name; }
        }

        public String Platform
        {
            get { return platform; }
        }

       

        public String RomType
        {
            get { return rom_type; }
        }

        public int DeclaratedSize
        {
            get { return declarated_size; }
        }

        public String Region
        {
            get { return "" + (char)bin_data[62]; }
            set { }
        }
    }
}
