
#include "types.h"
#include "psg.h"

void PSG_init() {

    u16 i;

    for (i = 0; i < 4; i++) {
		PSG_setEnvelope(i, PSG_ENVELOPE_MIN);
		PSG_setFrequency(i, 0);
		PSG_setTone(i, 0);
    }
	
}

void PSG_write(u8 data) {

    *((volatile u8*) PSG_PORT) = data;
}

void PSG_setEnvelope(u8 channel, u8 value) {

    *((volatile u8*) PSG_PORT) = 0x90 | ((channel & 3) << 5) | (value & 0xF);
}

void PSG_setTone(u8 channel, u16 value) {

    *((volatile u8*) PSG_PORT) = 0x80 | ((channel & 3) << 5) | (value & 0xF);
    *((volatile u8*) PSG_PORT) = (value >> 4) & 0x3F;
}

void PSG_setFrequency(u8 channel, u16 value) {

    u16 data;
    if (value) {

        data = 3546893 / (value * 32);
    } else {
        data = 0;
    }

    *((volatile u8*) PSG_PORT) = 0x80 | ((channel & 3) << 5) | (data & 0xF);
    *((volatile u8*) PSG_PORT) = (data >> 4) & 0x3F;
}
