
#include "types.h"
#include "ym2612.h"
#include "z80_ctrl.h"


void YM2612_reset() {
	

	s16 aa, bb, cc, pp;
	ym2612_wrie(0x2f, 0, 0xaa); /* freq.scaler */
    ym2612_wrie(0x2d, 0, 0xaa);
    ym2612_wrie(0x22, 0, 0xaa); /* LFO off */
    ym2612_wrie(0x2b, 0, 0xaa); /* DAC off */
    ym2612_wrie(0x27, 0, 0xaa); /* CH3 normal mode */
    ym2612_wrie(0x27, 0, 1); /* CH3 normal mode */
    for (cc = 0; cc < 2; cc++) {
        for (aa = 0; aa < 3; aa++) {
            for (bb = 0x30; bb < 0x40; bb += 4) ym2612_wrie(aa + bb, 0x00, cc); /* dt1/mul */
            for (bb = 0x40; bb < 0x50; bb += 4) ym2612_wrie(aa + bb, 0x7f, cc); /* tl */
            for (bb = 0x50; bb < 0x60; bb += 4) ym2612_wrie(aa + bb, 0x00, cc); /* rs/ar */
            for (bb = 0x60; bb < 0x70; bb += 4) ym2612_wrie(aa + bb, 0x00, cc); /* am/d1r */
            for (bb = 0x70; bb < 0x80; bb += 4) ym2612_wrie(aa + bb, 0x00, cc); /* d2r */
            for (bb = 0x80; bb < 0x90; bb += 4) ym2612_wrie(aa + bb, 0x0f, cc); /* d1l/rr */
            for (bb = 0x90; bb < 0xa0; bb += 4) ym2612_wrie(aa + bb, 0x00, cc); /* ssg-eg */
            ym2612_wrie(0xb0 + bb, 0x00, cc); /* fb/algo */
            ym2612_wrie(0xb4 + bb, 0x00, cc); /* ams/fms */
            ym2612_wrie(0x28, aa + (cc << 2), 0); /* keyoff */
        }
    }
}


void ym2612_wrie(u8 reg, u8 val, u8 bank){

	if(!bank){
		while(YM2612_IS_BUSY);
		*((volatile u8*)YM2612_A0) = reg;
		while(YM2612_IS_BUSY);
		*((volatile u8*)YM2612_D0) = val;
	}else{
		while(YM2612_IS_BUSY);
		*((volatile u8*)YM2612_A1) = reg;
		while(YM2612_IS_BUSY);
		*((volatile u8*)YM2612_D1) = val;
	}
}
