

int main() {


    configure();
    fatInitRam();
    fatInit();
    
    for(;;);

    return 0;
}

void configure() {

    u16 tv;
    u16 msg = 0;
    u16 sd_mode = 0;
    u8 buff[16];
    u16 firm;


    evd_init();
    //REG_MAX_MSG
    evd_setCfgBit(ED_CFG_SDRAM_ON, 0);
    dma_read_s(buff, ROM_ADDR + 0x20, 16);
    asm_date = memRomRead32(0x38);
    evd_setCfgBit(ED_CFG_SDRAM_ON, 1);

    firm = evd_readReg(REG_VER);

    if (streql("ED64 SD boot", buff, 12) && firm >= 0x0116) {
        sd_mode = 1;
    }
    //evd_writeReg(REG_MSG, 0);

    if (firm >= 0x0200) {
        sleep(1);
        evd_setCfgBit(ED_CFG_SDRAM_ON, 0);
        sleep(1);

        msg = evd_readReg(REG_MAX_MSG);

        tv = (msg >> 10) & 3;
        if (tv == 3)tv = 2;
        *(u32 *) 0x80000300 = tv;

        if (!(msg & (1 << 14))) {

            msg |= 1 << 14;
            evd_writeReg(REG_MAX_MSG, msg);
            loadFirmWare();
            sleep(1);
            evd_init();
        }
        sleep(1);

        evd_setCfgBit(ED_CFG_SDRAM_ON, 1);
    } else {
        evd_initSecurity();
    }

    if (sd_mode) {
        diskSetInterface(DISK_IFACE_SD);
    } else {
        diskSetInterface(DISK_IFACE_SPI);
    }
    memSpiSetDma(0);

}