#include <dma.h>
#include <n64sys.h>


#include "sys.h"

#include "types.h"
#include "everdrive.h"
#include "errors.h"
#include "usb.h"
#include "gui.h"
#include "graphics.h"


u32 asm_date;

Options_st options;

u32 native_tv_mode;

#define CIC_6101 1
#define CIC_6102 2
#define CIC_6103 3
#define CIC_6104 4
#define CIC_6105 5
#define CIC_6106 6

u16 strcon(u8 *str1, u8 *str2, u8 *dst, u16 max_len) {

    u16 len = 0;
    max_len -= 1;

    while (*str1 != 0 && len < max_len) {
        *dst++ = *str1++;
        len++;
    }

    while (*str2 != 0 && len < max_len) {
        *dst++ = *str2++;
        len++;
    }
    *dst++ = 0;
    return len;

}

void dma_read_s(void * ram_address, unsigned long pi_address, unsigned long len) {

    u32 buff[256];
    u32 *bptr;
    u32 *rptr = (u32 *) ram_address;
    u16 i;

    //u16 blen = 512;
    //if (len < 512)blen = len;
    //*(volatile u32*) 0x1FC007FC = 0x08;

    IO_WRITE(PI_STATUS_REG, 3);
    while (len) {
        dma_read(buff, pi_address, 512);
        while ((IO_READ(PI_STATUS_REG) & 3) != 0);
        //while ((*((volatile u32*) PI_STATUS_REG) & 0x02) != 1);
        data_cache_invalidate(buff, 512);
        bptr = buff;
        for (i = 0; i < 512 && i < len; i += 4)*rptr++ = *bptr++;
        len = len < 512 ? 0 : len - 512;
        pi_address += 512;
    }
}

void dma_write_s(void * ram_address, unsigned long pi_address, unsigned long len) {

    data_cache_writeback(ram_address, len);
    dma_write(ram_address, pi_address, len);

}

void joyWait() {


    while (1) {
        sleep(1);
        usbListener();
        if (joyIsReleased())break;
    }

    while (1) {
        sleep(1);
        usbListener();
        if (!joyIsReleased())break;
    }

}

u8 joyIsReleased() {

    struct controller_data cd;
    controller_scan();
    cd = get_keys_pressed();
    return (cd.c[0].up | cd.c[0].down | cd.c[0].A | cd.c[0].B | cd.c[0].start | cd.c[0].left
            | cd.c[0].right | cd.c[0].R | cd.c[0].L | cd.c[0].C_up | cd.c[0].Z | cd.c[0].C_down | cd.c[0].C_left | cd.c[0].C_right) == 0;

}

void joyWaitPadsRelease() {

    while (1) {
        sleep(1);
        if (joyIsReleased())return;
    }
}

/*
void showError(char *str, u32 code) {


    console_printf("%s%u\n", str, code);
    joyWait();


}
 */
void sleep(u32 ms) {

    u32 current_ms = get_ticks_ms();

    while (get_ticks_ms() - current_ms < ms);

}

void dma_read_sram(void *dest, u32 offset, u32 size) {
    /*
        PI_DMAWait();

        IO_WRITE(PI_STATUS_REG, 0x03);
        IO_WRITE(PI_DRAM_ADDR_REG, K1_TO_PHYS(dest));
        IO_WRITE(PI_CART_ADDR_REG, (0xA8000000 + offset));
        data_cache_invalidate_all();
        IO_WRITE(PI_WR_LEN_REG, (size - 1));
     * 0xA8000000
     * 0xb0000000
     *  0x4000000
     * */
    dma_read_s(dest, 0xA8000000 + offset, size);
    //data_cache_invalidate(dest,size);

}

void dma_write_sram(void* src, u32 offset, u32 size) {
    /*
        PI_DMAWait();

        IO_WRITE(PI_STATUS_REG, 0x02);
        IO_WRITE(PI_DRAM_ADDR_REG, K1_TO_PHYS(src));
        IO_WRITE(PI_CART_ADDR_REG, (0xA8000000 + offset));
        data_cache_invalidate_all();
        IO_WRITE(PI_RD_LEN_REG, (size - 1));*/

    dma_write_s(src, 0xA8000000 + offset, size);

}

#define DO1(buf) crc = crc_table[((int)crc ^ (*buf++)) & 0xff] ^ (crc >> 8);
#define DO2(buf)  DO1(buf); DO1(buf);
#define DO4(buf)  DO2(buf); DO2(buf);
#define DO8(buf)  DO4(buf); DO4(buf);

unsigned int CRC_Calculate(unsigned int crc, unsigned char* buf, unsigned int len) {
    static unsigned int crc_table[256];
    static int make_crc_table = 1;

    if (make_crc_table) {
        unsigned int c, n;
        int k;
        unsigned int poly;
        const unsigned char p[] = {0, 1, 2, 4, 5, 7, 8, 10, 11, 12, 16, 22, 23, 26};

        /* make exclusive-or pattern from polynomial (0xedb88320L) */
        poly = 0L;
        for (n = 0; n < sizeof (p) / sizeof (unsigned char); n++)
            poly |= 1L << (31 - p[n]);

        for (n = 0; n < 256; n++) {
            c = n;
            for (k = 0; k < 8; k++)
                c = c & 1 ? poly ^ (c >> 1) : c >> 1;
            crc_table[n] = c;
        }
        make_crc_table = 0;
    }

    if (buf == (void*) 0) return 0L;

    crc = crc ^ 0xffffffffL;
    while (len >= 8) {
        DO8(buf);
        len -= 8;
    }
    if (len)
        do {
            DO1(buf);
        } while (--len);

    return crc ^ 0xffffffffL;
}

int get_cic(unsigned char *buffer) {
    unsigned int crc;
    // figure out the CIC
    crc = CRC_Calculate(0, buffer, 1000);
    switch (crc) {
        case 0x303faac9:
        case 0xf0da3d50:
            return 1;
        case 0xf3106101:
            return 2;
        case 0xe7cd9d51:
            return 3;
        case 0x7ae65c9:
            return 5;
        case 0x86015f8f:
            return 6;
    }
    return 2;
}

u8 getCicType(u8 bios_cic) {

    u8 cic_buff[2048];
    volatile u8 cic_chip;
    volatile u32 val; // = *(u32 *) 0xB0000170;
    if (bios_cic) {
        evd_setCfgBit(ED_CFG_SDRAM_ON, 0);
        sleep(10);
        val = *(u32 *) 0xB0000170;
        dma_read_s(cic_buff, 0xB0000040, 1024);
        cic_chip = get_cic(cic_buff);
        evd_setCfgBit(ED_CFG_SDRAM_ON, 1);
        sleep(10);

    } else {
        val = *(u32 *) 0xB0000170;
        dma_read_s(cic_buff, 0xB0000040, 1024);
        cic_chip = get_cic(cic_buff);

    }

    /*
        if (val == 0x0D0001EC)cic_chip = CIC_6106;
        else
            if (val == 0x0D0001DB)cic_chip = CIC_6103;
        else
            if (val == 0xAD400014)cic_chip = CIC_6105;
        else
            cic_chip = CIC_6102;*/
    /*
        if (bios_cic) {
            console_printf("sys cic: %d\n", cic_chip);
        } else {
            console_printf("gam cic: %d\n", cic_chip);
        }*/

    //joyWait();


    return cic_chip;
}

u32 ii;
volatile u32 *pt;
void clean();

#define MEM32(addr) *((volatile u32 *)addr)

void setColor(u32 fcolor, u32 bcolor) {


    u8 r = fcolor >> 16;
    u8 g = fcolor >> 8;
    u8 b = fcolor >> 0;
    r >>= 3;
    g >>= 3;
    b >>= 3;

    fcolor = r << 11 | g << 6 | b << 1 | 1;

    r = bcolor >> 16;
    g = bcolor >> 8;
    b = bcolor >> 0;
    r >>= 3;
    g >>= 3;
    b >>= 3;
    bcolor = r << 11 | g << 6 | b << 1 | (bcolor == 0 ? 0 : 1);



    //bcolor = graphics_make_color(bcolor >> 16, bcolor >> 8, bcolor, 1);
    //fcolor = graphics_make_color(fcolor >> 16, fcolor >> 8, fcolor, 1);


    graphics_set_color(fcolor, bcolor);
}

u32 getColor(u32 fcolor) {

    u8 r = fcolor >> 16;
    u8 g = fcolor >> 8;
    u8 b = fcolor >> 0;
    r >>= 3;
    g >>= 3;
    b >>= 3;
    fcolor = r << 11 | g << 6 | b << 1 | 1;

    return fcolor;
}

u8 str_buff[128];

u8 STR_intToDecString(u32 val, u8 *str) {

    int len;

    if (val < 10)len = 1;
    else
        if (val < 100)len = 2;
    else
        if (val < 1000)len = 3;
    else
        if (val < 10000)len = 4;
    else
        if (val < 100000)len = 5;
    else
        if (val < 1000000)len = 6;
    else
        if (val < 10000000)len = 7;
    else
        if (val < 100000000)len = 8;
    else
        if (val < 1000000000)len = 9;
    else len = 10;

    str += len;
    str[0] = 0;
    if (val == 0)*--str = '0';
    while (val) {

        *--str = '0' + val % 10;
        val /= 10;
    }


    return len;
}

void STR_intToDecStringMin(u32 val, u8 *str, u8 min_size) {

    int len;
    u8 i;

    if (val < 10)len = 1;
    else
        if (val < 100)len = 2;
    else
        if (val < 1000)len = 3;
    else
        if (val < 10000)len = 4;
    else
        if (val < 100000)len = 5;
    else
        if (val < 1000000)len = 6;
    else
        if (val < 10000000)len = 7;
    else
        if (val < 100000000)len = 8;
    else
        if (val < 1000000000)len = 9;
    else len = 10;

    if (len < min_size) {

        i = min_size - len;
        while (i--)str[i] = '0';
        len = min_size;
    }
    str += len;
    str[0] = 0;
    if (val == 0)*--str = '0';
    while (val) {

        *--str = '0' + val % 10;
        val /= 10;
    }
}

void drawNum(char *coment, u32 num, char *coment2, u16 x, u16 y, const display_context_t dc) {

    u8 comment_len = 0;
    //num = 11;
    while (coment[comment_len] != 0) {
        str_buff[comment_len] = coment[comment_len];
        comment_len++;
    }
    STR_intToDecString(num, &str_buff[comment_len]);
    while (str_buff[comment_len] != 0)comment_len++;

    while (*coment2 != 0)str_buff[comment_len++] = *coment2++;
    str_buff[comment_len] = 0;

    //VDP_drawText(APLAN, str_buff, base, x, y);
    //graphics_draw_text(dc, x, y, (char *) str_buff);
    gDrawString(str_buff, x, y);
}

u8 streq(u8 *str1, u8 *str2) {

    u8 s1;
    u8 s2;

    for (;;) {
        s1 = *str1++;
        s2 = *str2++;
        if (s1 >= 'a' && s1 <= 'z')s1 -= 0x20;
        if (s2 >= 'a' && s2 <= 'z')s2 -= 0x20;

        if (s1 != s2) return 0;

        if (*str1 == 0 && *str2 == 0)return 1;
    }
}

u8 streql(u8 *str1, u8 *str2, u8 len) {

    u8 s1;
    u8 s2;
    while (len--) {

        s1 = *str1++;
        s2 = *str2++;
        if (s1 >= 'a' && s1 <= 'z')s1 -= 0x20;
        if (s2 >= 'a' && s2 <= 'z')s2 -= 0x20;

        if (s1 != s2) return 0;
    }

    return 1;
}

u16 strContain(u8 *target, u8 *str) {

    u16 targ_len = slen(target);
    u16 eq_len;


    for (eq_len = 0; eq_len < targ_len;) {

        if (*str == 0)return 0;
        if (*str++ == target[eq_len]) {
            eq_len++;
        } else {
            eq_len = 0;
        }
    }

    if (eq_len != targ_len)return 0;
    return 1;

}

u8 slen(u8 *str) {

    u8 len = 0;
    while (*str++)len++;
    return len;
}

u8 scopy(u8 *src, u8 *dst) {

    u8 len = 0;
    while (*src != 0) {
        *dst++ = *src++;
        len++;
    }
    *dst = 0;
    return len;
}

void strhicase(u8 *str, u8 len) {

    if (len) {
        while (len--) {
            if (*str >= 'a' && *str <= 'z')*str -= 0x20;
            str++;
        }
    } else {
        while (*str != 0) {
            if (*str >= 'a' && *str <= 'z')*str -= 0x20;
            str++;
        }
    }

}

void showError(u8 *message, u32 code) {


    if (code == ERR_EMU_NOT_FOUND) {
        showMessageNum("ERROR", "emulator not found: ", code);
    } else {
        showMessageNum("ERROR", message, code);
    }
    joyWait();
    joyWaitPadsRelease();
}

void showMessageNum(u8 *title, u8 *message, u32 num) {

    u8 buff[128];
    u16 ms_len = slen(message);

    scopy(message, buff);
    STR_intToDecString(num, &buff[ms_len]);
    showMessage(title, buff);

}

void showMessage(u8 *title, u8 *message) {




    GuiWin win;
    win.body_trans = 0;
    win.color = GUI_COLOR_WIN;
    win.title = title;
    win.w = 320;
    win.h = 192;
    win.x = 0;
    win.y = 0;
    guiDrawWin(&win);
    gDrawString(message, guiGetCX(slen(message) * gGetFontW()), guiGetCY(gGetFontH()));
    gSwapFrameBuff();
    /*
    u16 i;
    u16 ttlen = 0;
    u16 mslen = 0;
    u16 w = 0;
    u16 h = 0;
    u16 x = 0;
    u16 y = 0;
    u32 wcolor = getColor(0xaaaaaa);
    u32 msolor = getColor(0x4444aa);
    u16 str_ctr = 1;
    u16 ctr = 0;

    display_context_t dc;
    dc = display_get_context();
    //graphics_fill_screen(dc, 0);
    fillBg();


    for (i = 0; message[i] != 0; i++)if (message[i] == '\n')str_ctr++;

    if (title != 0) {
        ttlen = slen(title);
    }
    if (message != 0) {
        //mslen = slen(message);
        for (i = 0; message[i] != 0; i++) {
            ctr++;
            mslen = ctr > mslen ? ctr : mslen;
            if (message[i] == '\n') ctr = 0;
        }

    }

    w = ttlen > mslen ? ttlen : mslen;
    w *= 8;
    w += 16;
    if (w < 64)w = 64;

    h = 40 + str_ctr * 10;

    if (h < 64)h = 64;


    x = (320 - w) / 2;
    y = (240 - h) / 2;

    graphics_draw_box(dc, x + 4, y + 4, w, h, getColor(0));
    graphics_draw_box(dc, x, y, w, h, wcolor);
    graphics_draw_box(dc, x, y, w, 16, msolor);

    graphics_set_color(getColor(0xffffff), msolor);
    graphics_draw_text(dc, x + 8, y + 4, title);

    y += 16 + 4 + 8;
    graphics_set_color(getColor(0), wcolor);
    graphics_draw_text(dc, x + 8, y + 4, message);

    display_show(dc);*/
}

void fillBg() {

    u16 i;
    display_context_t dc;
    dc = display_get_context();
    //graphics_fill_screen(dc, 0);

    for (i = 0; i < 480; i += 20) {
        graphics_draw_box(dc, 0, i, 640, 20, getColor(i / 4));
    }

} 