
#include "types.h"
#include "z80_ctrl.h"


void Z80_init(){
    
    u16 i;
    Z80_BUSREQ_ON;
    Z80_RESET_OFF;
    while (Z80_IS_BUSREQ_OFF);
    i = 8192;
    while (i--)((u8 *) Z80_RAM)[i] = 0;
    Z80_BUSREQ_OFF;
    
}

void Z80_loadDriver(const u8 *driver, u16 len) {

    volatile u8 *z80_ram_ptr = (u8 *) Z80_RAM;
    const volatile u8 *driver_prt = driver;
    Z80_BUSREQ_ON;
    Z80_RESET_OFF;
    while (Z80_IS_BUSREQ_OFF);
    while (len--)*(z80_ram_ptr++) = *(driver_prt++);
    Z80_RESET_ON;
    Z80_BUSREQ_OFF;
    Z80_RESET_OFF;
}

void Z80_setBank(const u16 bank) {

    u16 i, value;
    i = 9;
    value = bank;
    while (i--) {
        *((volatile u8 *) Z80_BANK_REGISTER) = value;
        value >>= 1;
    }
}
