#ifndef _BITMAP_H_
#define _BITMAP_H_


#define BITMAP_PIXWIDTH         (BITMAP_WIDTH * 4)
#define BITMAP_PIXHEIGHT        (BITMAP_HEIGHT * 8)

#define BITMAP_PITCH            (BITMAP_WIDTH * 4)


extern u8 BitmapBuffer[BITMAP_PITCH * BITMAP_PIXHEIGHT];

extern u16 bitmap_width_tile;
extern u16 bitmap_height_tile;
extern u16 bitmap_width_pixel;
extern u16 bitmap_height_pixel;


void setBitmapMode(u16 w, u16 h);

void loadBitmapFromU16(const u16 *data, u16 x, u16 y, u16 w, u16 h, u16 pitch);
void loadBitmap(const u32 *data, u16 x, u16 y, u16 w, u16 h, u16 pitch);

void clearBitmapAll();
void clearBitmap(u16 x, u16 y, u16 w, u16 h);
void blitBitmapAll();
void blitBitmap(u16 x, u16 y, u16 w, u16 h);
void blitAndClearBitmapAll();
void blitAndClearBitmap(u16 x, u16 y, u16 w, u16 h);

void loadGenBmp16ToBitmap(const u16 *genbmp16, u16 x, u16 y, u16 loadpalto);
void getGenBmp16Palette(const u16 *genbmp16, u16 *pal);


#endif // _BITMAP_H_
