#ifndef _BITMAPX_H_
#define _BITMAPX_H_


#define BITMAP_SETPIXELDIRECT(x, y, c)              \
{                                                   \
    volatile u32 *plctrl;                           \
    volatile u16 *pwdata;                           \
    u16 addr;                                       \
    u16 data;                                       \
                                                                            \
    addr = TILE_BITMAP + ((((x) >> 2) + (((y) >> 3) * BITMAP_WIDTH)) * 32); \
    addr += ((x) & 2) + (((y) & 7) * 4);                                    \
                                                    \
    plctrl = (u32 *) GFX_CTRL_PORT;                 \
    pwdata = (u16 *) GFX_DATA_PORT;                 \
                                                    \
    *plctrl = GFX_READ_VRAM_ADDR(addr);             \
    data = *pwdata;                                 \
                                                    \
    *plctrl = GFX_WRITE_VRAM_ADDR(addr);            \
    if ((x) & 1) *pwdata = (data & 0xFF00) | (c);   \
    else *pwdata = (data & 0x00FF) | ((c) << 8);    \
}

#define BITMAP_SETPIXELDIRECT_SAFE(x, y, c)             \
{                                                       \
    volatile u32 *plctrl;                               \
    volatile u16 *pwdata;                               \
    u16 addr;                                           \
    u16 data;                                           \
                                                                                                \
    if (((unsigned)(x) < bitmap_width_pixel) && ((unsigned)(y) < bitmap_height_pixel))    \
    {                                                                                           \
        addr = TILE_BITMAP + ((((x) >> 2) + (((y) >> 3) * BITMAP_WIDTH)) * 32);                 \
        addr += ((x) & 2) + (((y) & 7) * 4);                                                    \
                                                        \
        plctrl = (u32 *) GFX_CTRL_PORT;                 \
        pwdata = (u16 *) GFX_DATA_PORT;                 \
                                                        \
        *plctrl = GFX_READ_VRAM_ADDR(addr);             \
        data = *pwdata;                                 \
                                                        \
        *plctrl = GFX_WRITE_VRAM_ADDR(addr);            \
        if ((x) & 1) *pwdata = (data & 0xFF00) | (c);   \
        else *pwdata = (data & 0x00FF) | ((c) << 8);    \
    }                                                   \
}

#define BITMAP_SETPIXEL(x, y, c)                    \
    BitmapBuffer[(x) + ((y) * BITMAP_PITCH)] = c;

#define BITMAP_SETPIXEL_SAFE(x, y, c)                                                   \
    if (((unsigned)(x) < bitmap_width_pixel) && ((unsigned)(y) < bitmap_height_pixel))  \
    {                                                                                   \
        BitmapBuffer[(x) + ((y) * BITMAP_PITCH)] = c;                                   \
    }


u8 getPixelDirect(s16 x, s16 y);
void setPixelDirect(s16 x, s16 y, u8 col);

u8 getPixel(s16 x, s16 y);
void setPixel(s16 x, s16 y, u8 col);

void drawLine(s16 x1, s16 y1, s16 x2, s16 y2, u8 col);

void drawPolygone(vect2D_s16 *pts, u16 numpts, u8 col, u8 culling);


#endif // _BITMAPX_H_
