#include "types.h"

#include "vdp.h"
#include "vdp_bg.h"

void VDP_setHorizontalScroll(u16 plan, u16 line, u16 value) {

    u16 addr;
    
    addr = HSCRL + ((line & 0xFF) * 4);
    if (plan == BPLAN) addr += 2;

    *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(addr);
    *vdp_data_port_ptr16 = value;
}

void VDP_setVerticalScroll(u16 plan, u16 cell, u16 value) {

    u16 addr;

    addr = (cell & 0x1F) * 4;
    if (plan == BPLAN) addr += 2;

    *vdp_ctrl_port_ptr32 = GFX_WRITE_VSRAM_ADDR(addr);
    *vdp_data_port_ptr16 = value;
}

