#ifndef _VDP_TILE_H_
#define _VDP_TILE_H_


#define TILE_ATTR(pal, pri, flipV, flipH)   (((flipH) << 11) + ((flipV) << 12) + ((pal) << 13) + ((pri) << 15))
#define TILE_PAL(pal)((pal << 13))

void VDP_loadTileTo(const u32 *data, u16 index, u16 num, u8 use_dma);
void VDP_loadFont(const u32 *font, u8 use_dma);

void VDP_setTile(u16 plan, u16 tile, u16 x, u16 y);
void VDP_fillTileRect(u16 plan, u16 tile, u16 x, u16 y, u16 w, u16 h);
void VDP_fillTileRectInc(u16 plan, u16 basetile, u16 x, u16 y, u16 w, u16 h);
void VDP_setTileRect(u16 plan, const u16 *data, u16 basetile, u16 x, u16 y, u16 w, u16 h);

void VDP_drawText(u16 plan, const char *str, u16 basetile, u16 x, u16 y);
void VDP_setTileRectDma(u16 plan, const u16 *data, u16 x, u16 y, u16 w, u16 h);

#endif // _VDP_TILE_H_
