

#include "genesis.h"
#include "sprite.h"
#include "map.h"


_spritedef sprites[SPRITE_TOTAL_NUM];
u16 sprite_counter;
u16 color_strobe;
u8 ani_counter;

void spriteInit() {

    ani_counter = 0;
    color_strobe = 0;
    sprite_counter = 0;
    VDP_resetSprites();
    VDP_updateSprites();
}

void drawSprite2x2(u16 sprite_atr, s16 x, s16 y) {

    sprite_counter++;
    VDP_setSprite(x + MAP_PIXEL_X, y + MAP_PIXEL_Y, SPRITE_SIZE(2, 2), sprite_atr, sprite_counter);
}

void drawSprite8x8(u16 sprite_atr, s16 x, s16 y) {

    sprite_counter++;
    VDP_setSprite(x + MAP_PIXEL_X, y + MAP_PIXEL_Y, SPRITE_SIZE(8, 8), sprite_atr, sprite_counter);
}

void drawSprite1x2(u16 sprite_atr, s16 x, s16 y) {

    sprite_counter++;
    VDP_setSprite(x + MAP_PIXEL_X, y + MAP_PIXEL_Y, SPRITE_SIZE(1, 2), sprite_atr, sprite_counter);
}

void drawSprite4x1(u16 sprite_atr, s16 x, s16 y) {

    sprite_counter++;
    VDP_setSprite(x + MAP_PIXEL_X, y + MAP_PIXEL_Y, SPRITE_SIZE(4, 1), sprite_atr | TILE_ATTR(0, 1, 0, 0), sprite_counter);

}

void updateSprite() {

    ani_counter++;
    color_strobe++;
    VDP_setSprite(0, 0, 0, 0, 0);
    VDP_updateSpritesDma();
    sprite_counter = 0;
}

void drawTank(_tank *sprite) {

    u16 color;
    u16 attr;

    if (!sprite->hitpoint)return;
    if (sprite->freeze && (ani_counter & 31) < 16)return;

    if (sprite->birth) {
        drawSprite2x2(SPRITE_ADDR_BIRTH + ((sprite->birth >> 2 & 3) << 2), sprite->posx, sprite->posy);
        return;
    }

    if (sprite->god) {
        drawSprite2x2(SPRITE_ADDR_ARMOR + ((sprite->god >> 1 & 1) << 2), sprite->posx, sprite->posy);

    }

    color = sprite->color;
    if (sprite->bonus) {
        color = TANK_COLOR_GREY;
        if ((color_strobe & 0xf) < 8)color = TANK_COLOR_RED;
    }
    else {
        if (sprite->hitpoint > 1 && (color_strobe & 1)) {

            color = sprite->hitpoint == 4 ? TANK_COLOR_GREEN : TANK_COLOR_YELLOW;
        }
        if (sprite->hitpoint == 2 && !(color_strobe & 1))color = TANK_COLOR_GREEN;

    }


    attr = SPRITE_ADDR_TANK | TILE_PAL(color);
    attr += sprite->type << 5;
    attr += sprite->rotate << 3;
    if (sprite->speed && !pause)attr += ((ani_counter >> 2) & 1) << 2;


    sprite_counter++;
    VDP_setSprite(sprite->posx + MAP_PIXEL_X, sprite->posy + MAP_PIXEL_Y, SPRITE_SIZE(2, 2), attr, sprite_counter);

}

void drawBonus(_bonus *bonus) {

    if ((ani_counter & 15) < 8)return;

    drawSprite2x2((SPRITE_BONUS + ((bonus->type - 1) << 2)) | TILE_ATTR(0, 1, 0, 0), bonus->posx, bonus->posy);
}
