/*
 * File:   main.c
 * Author: krikzz
 *
 * Created on 23.06.2010
 */

#include "../../lib/segalib.h"
#include "../../lib/fifo.h"


//image with and height should be multiple to 8
//image palette should contain not more than 16 colors
asm(".global tigra_pic");
asm("tigra_pic:");
asm(".incbin \"tigra.gif-pix.bin\"");
asm(".global tigra_pal");
asm("tigra_pal:");
asm(".incbin \"tigra.gif-pal.bin\"");

extern const u16 tigra_pal[];
extern const u32 tigra_pic[];

int main() {


    u16 i = 0;
    //u8 u = 0;
    VDP_init();

    //1120 = (320/8) * (224 / 8) num of 8x8 tiles in image
    VDP_loadTileTo(tigra_pic, 1, 1120, 0);
    VDP_setPalette(0, tigra_pal);
    VDP_fillTileRectInc(APLAN, 1, 0, 0, 40, 28); //draw image 320x240 (40x28 tiles)



    //main loop
    for (;;) {

        i++;
        if (i % 200 < 100) {
            VDP_setHorizontalScroll(APLAN, 0, i % 100-50);
        } else {
            VDP_setHorizontalScroll(APLAN, 0, 50 - i % 100);
        }
        VDP_waitVSync();

    }

    return 0;
}

void vb() {
    //vblank interrupt
}

void hb() {
    //hblank interrupt
}

void in() {
    //all other interrupts
}
