/*
 * File:   main.c
 * Author: krikzz
 *
 * Created on 23.06.2010
 */

#include "../../lib/segalib.h"
#include "../../lib/fifo.h"


//image with and height should be multiple to 8
//image palette should contain not more than 16 colors
asm(".global tank_pic");
asm("tank_pic:");
asm(".incbin \"tank.gif-pix.bin\"");
asm(".global tank_pal");
asm("tank_pal:");
asm(".incbin \"tank.gif-pal.bin\"");

extern const u16 tank_pal[];
extern const u32 tank_pic[];

//each sprite use 4 words by 16 bit
u16 sprite_buff[32];

int main() {

    u16 joy;
    u8 current_unit = 0;
    u8 flip_v;
    u8 x[3];
    u8 y[3];

    x[0] = 100;
    x[1] = 116;
    x[2] = 132;
    y[0] = 100;
    y[1] = 100;
    y[2] = 100;

    VDP_init();
    JOY_init();

    VDP_loadTileTo(tank_pic, 1, 8, 0);
    VDP_setPalette(0, tank_pal);
    VDP_setPalette(1, tank_pal); //load tank pal
    VDP_setPaletteColor(1, 2, 0xf0f); //change color 2 in just loaded pal



    //main loop
    for (;;) {


        joy = JOY_readJoypad(JOY_1);
        flip_v = 0;


        //change conrolled car
        if ((joy & BUTTON_A)) current_unit = 0;
        if ((joy & BUTTON_B)) current_unit = 1;
        if ((joy & BUTTON_C)) current_unit = 2;

        if ((joy & BUTTON_UP)) {
            y[current_unit]--;
        }
        if ((joy & BUTTON_DOWN)) {
            y[current_unit]++;
            flip_v = 1;
        }
        if ((joy & BUTTON_LEFT)) {
            x[current_unit]--;
        }
        if ((joy & BUTTON_RIGHT)) {
            x[current_unit]++;
        }


        VDP_waitVSync();
        VDP_addSprite(&sprite_buff[0], x[0], y[0], SPRITE_SIZE(2, 2), 1, 1);
        VDP_addSprite(&sprite_buff[4], x[1], y[1], SPRITE_SIZE(2, 2), 5 | TILE_ATTR(1, 0, flip_v, 0), 2); //sprite with changed pal and flips
        VDP_addSprite(&sprite_buff[8], x[2], y[2], SPRITE_SIZE(2, 2), 5, 3);
        VDP_spriteBuffToVram(sprite_buff, 3);
    }

    return 0;
}

void vb() {
    //vblank interrupt
}

void hb() {
    //hblank interrupt
}

void in() {
    //all other interrupts
}
