/* 
 * File:   cart.h
 * Author: KRIK
 *
 * Created on 8  2009 ., 3:09
 */

#ifndef _HARD
#define _HARD

#define _SS 0
#define _FULL_SPEED 1
#define _SPI16 2
#define _GAME_MODE 3
#define _SMS_MODE 4
#define _HARD_RESET 5
#define _RAM_MODE_1 6
#define _RAM_ON 7
#define _VBL_CATCH 8
#define _MEGAKEY_ON 9
#define _MEGAKEY_REGION_1 10

#define REGION_NTSC 0
#define REGION_PAL 1
#define REGION_MULTI 2

#define GET_CONSOGE_REGION (*((volatile u16*) (0xa10000)) >> 6 & 1)

#define _SPI_READY 0
#define _RY 1


#define SPI_PORT *((volatile u16*) (0xA13000))
#define CFG_PORT *((volatile u16*) (0xA13002))
#define VBL_PORT *((volatile u16*) (0xA13004))
#define SRAM_BANK_PORT *((volatile u16*) (0xA13006))
#define VER_PORT *((volatile u16*) (0xA13008))


#define CFGC(bit)(cfg &= ~(1 << bit), CFG_PORT = cfg)
#define CFGS(bit)(cfg |= (1 << bit), CFG_PORT = cfg)

#define SPI_HI_SPEED_ON CFGS(_FULL_SPEED)
#define SPI_HI_SPEED_OFF CFGC(_FULL_SPEED)

#define SPI16_ON CFGS(_SPI16);
#define SPI16_OFF CFGC(_SPI16);

#define SS_ON CFGC(_SS)
#define SS_OFF CFGS(_SS)


#define IS_RY (CFG_PORT & (1 << _RY))
#define IS_SPI_READY (CFG_PORT & (1 << _SPI_READY))

#define SPI_BUSY while(!IS_SPI_READY)
#define EPR_BUSY while(!IS_RY)

#define RAM_ON CFGS(_RAM_ON);
#define RAM_OFF CFGC(_RAM_ON);


#define VBL_CATCH_ON CFGS(_VBL_CATCH);
#define VBL_CATCH_OFF CFGC(_VBL_CATCH);


u16 cfg;

#endif
