
#include "lib/vdp.h"
#include "lib/joy.h"
#include "select_file_.h"
#include "fat16_.h"
#include "tools_.h"
#include "globals_.h"
#include "mmc_.h"
#include "tfcplayer_gcc.h"


u8 loadAudio(Fat16Record *rec);
#define MENU_ITEMS 22

u8 audio_buff[1024 * 25];
u16 current_sound_entry;

Fat16Record* selectFile(u8 select_dir) {

    u16 i;
    u8 resp;
    u16 selector = 0;
    s16 item;
    s16 page;
    s16 page_items;
    u16 dir_tree[64];
    u16 dir_tree_top = 0;
    u16 key_friz = 0;
    u16 pages;
    tfc_init(audio_buff);
    current_sound_entry = 0;


    while (joy != 0);


    for (;;) {

        while (joy != 0);

        cy = 1;
        dir_tree_top = 0;
        selector = 0;

        VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
        VDP_fillTileRect(BPLAN, 0, 0, 0, 40, 28);
        VDP_drawText(APLAN, "init mmc...", 0, 1, cy++);
        resp = fat16Init();

        if (resp != 0) {
            drawNum("ERROR: fat init failed: ", resp, 0, 1, cy++);
            while (joy != 0);
            while (joy == 0);
            return 0;
        } else {
            VDP_drawText(APLAN, "ok", 0, 1, cy++);
        }

        resp = fat16OpenDir(0, &dir);

        VDP_drawText(APLAN, "open root...", 0, 1, cy++);
        if (resp != 0) {
            drawNum("ERROR: can not open root dir: ", resp, 0, 1, cy++);
            while (joy != 0);
            while (joy == 0);
            return 0;
        } else {
            VDP_drawText(APLAN, "ok", 0, 1, cy++);
        }

        VDP_fillTileRect(BPLAN, 0, 0, 0, 40, 28);
        VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);




        for (;;) {
            pages = dir.size / MENU_ITEMS;
            if (dir.size % MENU_ITEMS != 0)pages++;
            VDP_fillTileRect(BPLAN, 2, 0, 26, 40, 2);
            drawNum("page: ", selector / MENU_ITEMS + 1, 0, 1, 24);
            VDP_drawText(APLAN, "/", 0, 9, 24);
            drawNum("", pages, 0, 11, 24);
            VDP_drawTextAnc(APLAN, "(A)open dir, (left/right)select page", 0, 20, 26, CENTER);
            VDP_drawTextAnc(APLAN, "(B)back, (start)play, (C)stop", 0, 20, 27, CENTER);

            drawDir(1, 1, selector, current_sound_entry, MENU_ITEMS);
            //VDP_drawText(APLAN, "current sound: ", TILE_ATTR(2, 0, 0, 0), 1, 25);
            VDP_fillTileRect(APLAN, 0, 0, 25, 40, 1);
            if (current_sound_entry != 0) {
                VDP_drawText(APLAN, &audio_buff[50], TILE_ATTR(2, 0, 0, 0), 1, 25);
            }

            while (joy != 0 && key_friz < 30) {
                VDP_waitVSync();
                key_friz++;
            };
            while (joy != 0) {
                VDP_waitVSync();
                key_friz++;
                if (key_friz % 3 != 0)continue;
                break;
            }
            while (joy == 0)key_friz = 0;



            if ((joy & BUTTON_A) && (dir.records[selector].flags & FAT16_TYPE_DIR)) {
                VDP_fillTileRect(APLAN, 0, 0, 0, 40, 26);
                dir_tree[dir_tree_top++] = dir.entry;
                resp = fat16OpenDir(dir.records[selector].entry, &dir);

                selector = 0;
                if (resp != 0) {
                    cy = 1;
                    drawNum("ERROR: can not open dir: ", resp, 0, 1, cy++);
                    while (joy != 0);
                    while (joy == 0);
                    return 0;
                }
                key_friz = 0;
                continue;
            }

            if ((joy & BUTTON_C)) {

                tfc_play(0);
                current_sound_entry = 0;
                while (joy == 0);
                while (joy != 0);

            }

            if ((joy & BUTTON_START) && (dir.records[selector].flags & FAT16_TYPE_DIR) == 0) {

                //return &dir.records[selector];

                cy = 1;
                //VDP_drawText(APLAN, "loading...", 0, 1, cy++);
                tfc_play(0);
                current_sound_entry = 0;
                if (dir.records[selector].size > sizeof (audio_buff)) {
                    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
                    drawNum("ERROR: max file size is: ", sizeof (audio_buff), 0, 1, cy++);
                    while (joy != 0);
                    while (joy == 0);
                    while (joy != 0);
                    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
                    continue;
                }
                resp = loadAudio(&dir.records[selector]);
                if (resp != 0) {
                    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
                    drawNum("ERROR: can not load audio: ", resp, 0, 1, cy++);
                    while (joy != 0);
                    while (joy == 0);
                    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
                    return 0;
                }

                tfc_play(1);
                current_sound_entry = dir.records[selector].entry;

            }
            /*
                        if ((joy & BUTTON_START) && (dir.records[selector].flags & FAT16_TYPE_DIR) != 0 && select_dir && dir.size > 0) {

                            return &dir.records[selector];
                        }
             */
            if ((joy & BUTTON_B && dir_tree_top == 0)) {
                return 0;
            }

            if ((joy & BUTTON_B) && dir_tree_top != 0) {

                VDP_fillTileRect(APLAN, 0, 0, 0, 40, 26);
                dir_tree[dir_tree_top] = dir.entry;
                resp = fat16OpenDir(dir_tree[--dir_tree_top], &dir);
                for (i = 0; i < dir.size; i++) {
                    if (dir.records[i].entry == dir_tree[dir_tree_top + 1]) {
                        selector = i;
                        break;
                    }
                }
                if (resp != 0) {
                    cy = 1;

                    drawNum("ERROR: can not open dir: ", resp, 0, 1, cy++);
                    while (joy != 0);
                    while (joy == 0);
                    return 0;
                }

                key_friz = 0;
                continue;
            }



            if ((joy & BUTTON_UP)) {

                item = selector % MENU_ITEMS;
                page = selector / MENU_ITEMS;
                page_items = dir.size - page * MENU_ITEMS;
                if (page_items > MENU_ITEMS)page_items = MENU_ITEMS;
                item--;
                if (item < 0)item = page_items - 1;
                selector = page * MENU_ITEMS + item;

                continue;
            }

            if ((joy & BUTTON_DOWN)) {

                item = selector % MENU_ITEMS;
                page = selector / MENU_ITEMS;
                page_items = dir.size - page * MENU_ITEMS;
                if (page_items > MENU_ITEMS)page_items = MENU_ITEMS;
                item++;
                item %= page_items;
                selector = page * MENU_ITEMS + item;

                continue;
            }

            if ((joy & BUTTON_RIGHT) && dir.size > MENU_ITEMS) {

                item = selector % MENU_ITEMS;
                page = selector / MENU_ITEMS;
                page++;
                if (page * MENU_ITEMS >= dir.size) {
                    page = 0;
                }

                selector = page * MENU_ITEMS + item;
                if (selector >= dir.size)selector = dir.size - 1;
                key_friz = 0;
                VDP_waitVSync();
                VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
                continue;
            }

            if ((joy & BUTTON_LEFT) && dir.size > MENU_ITEMS) {

                item = selector % MENU_ITEMS;
                page = selector / MENU_ITEMS;
                page--;
                if (page < 0) {
                    page = dir.size / MENU_ITEMS - 1;
                    if (dir.size % MENU_ITEMS != 0)page++;
                }

                selector = page * MENU_ITEMS + item;
                if (selector >= dir.size)selector = dir.size - 1;
                key_friz = 0;
                VDP_waitVSync();
                VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
                continue;
            }
        }
    }

    return 0;

}

u8 loadAudio(Fat16Record *rec) {

    u8 *data_buff = audio_buff;
    u8 error;
    u32 addr = 0;
    error = fat16OpenFile(rec, &file);
    if (error)return 1;


    while (file.pos < file.record->size) {

        error = fat16SetNextReadSector(&file, &addr);
        if (error)return 3;
        error = mmcRdBlock(addr, data_buff);
        if (error)return 4;
        data_buff += 512;
    }

    return 0;
}
