

#include "genesis.h"
#include "game.h"
#include "map.h"
#include "resmap.h"
#include "map_editor.h"
#include "gameover.h"
#include "sprite.h"
#include "menu.h"
#include "collision.h"
#include "gamelogic.h"
#include "gamerender.h"
//#include "audio.h"

void selectLevel();
s16 selected_stage;

void drawStageNum(s16 num);
void startLevel();

void showGameover();
void joyEventGame(u16 joy, u16 changed, u16 state);
void vblankCB();
s16 game_over_timer;
volatile u16 vb_counter = 0;
void updateAudio();

#define RESET_KEY (BUTTON_A | BUTTON_B | BUTTON_C | BUTTON_START)

void vblankCB() {

    vb_counter++;
    GRend_repaint();
    u16 joy = JOY_readJoypad(JOY_1);
    if ((joy & RESET_KEY) == RESET_KEY) {
        asm("move.l 0x0004,%a0");
        asm("jmp (%a0)");
    }
}

u8 kills_1[4];
u8 kills_2[4];
u32 top_scor;
u16 level_timer;

void startGame() {


    VDP_setPalette(0, palette_black);
    VDP_resetSprites();
    VDP_updateSpritesDma();
    VDP_fillTileRect(APLAN, 0, 0, 0, vdp_plan_w, vdp_plan_h);


    VDP_setPalette(0, pal_red);
    VDP_setPalette(1, pal_yellow);
    VDP_setPalette(2, pal_green);
    VDP_setPalette(3, pal_grey);
    selected_stage = -1;
    gameover = 0;


    JOY_setEventHandler(joyEventGame);


    while (!GLog_gameover()) {

        level_timer = 0;
        selectLevel();
        startLevel();

        if (!GLog_gameover()) {

            showScore();
            selected_stage++;
        }
    }


}

void selectLevel() {

    u16 i;
    u16 joy = 0;
    s16 stage_ctr = 0;
    u8 init_logic = 0;
    updateSprite();

    if (selected_stage >= 0)stage_ctr = selected_stage;
    for (i = 0; i < 15; i++) {

        VDP_fillTileRect(APLAN, RES_TILE_GREY, 0, i, 40, 1);
        VDP_fillTileRect(APLAN, RES_TILE_GREY, 0, 28 - i, 40, 1);
        VDP_waitVSync();
    }

    VDP_fillTileRectInc(APLAN, RES_TILE_STAGE, 12, 13, 5, 1);
    drawStageNum(stage_ctr + 1);

    joy = JOY_readJoypad(JOY_1);

    while (joy)joy = JOY_readJoypad(JOY_1);

    while (selected_stage < 0) {

        init_logic = 1;
        joy = JOY_readJoypad(JOY_1);

        if (joy & BUTTON_B) {
            stage_ctr++;
            if (stage_ctr >= MAP_AVAILABLE)stage_ctr = MAP_AVAILABLE - 1;
            sleepFrames(10);
            drawStageNum(stage_ctr + 1);
        }
        if (joy & BUTTON_C) {
            stage_ctr--;
            if (stage_ctr < 0)stage_ctr = 0;
            sleepFrames(10);
            drawStageNum(stage_ctr + 1);
        }

        if (joy & BUTTON_START) {
            selected_stage = stage_ctr;
        }

    }

    if (init_logic)GLog_initGameLogic();

    //startPlaySample(snd_start, sizeof (snd_start), 10000, AUDIO_PAN_CENTER, 10);
    sleepFrames(64);


}

void drawStageNum(s16 num) {

    u16 num_1 = num / 10;
    u16 num_2 = num % 10;

    if (num_1 == 0) {
        VDP_setTile(APLAN, RES_TILE_GREY, 18, 13);
    } else {
        VDP_setTile(APLAN, RES_TILE_STAGE_NUM + num_1, 18, 13);
    }
    VDP_setTile(APLAN, RES_TILE_STAGE_NUM + num_2, 19, 13);


}

void startLevel() {

    u16 i;
    VDP_setPalette(0, palette_black);
    for (i = 0; i < MAX_BULLETES; i++)bullets[i].speed = 0;
    VDP_fillTileRect(APLAN, 0, 0, 0, vdp_plan_w, vdp_plan_h);
    VDP_fillTileRect(APLAN, RES_TILE_GREY, 0, 0, 40, 28);
    VDP_resetSprites();
    VDP_updateSpritesDma();
    u16 old_vb_counter = 0;

    GLog_initLEvel(selected_stage);
    for (i = 0; i < 4; i++) {
        kills_1[i] = 0;
        kills_2[i] = 0;
    }



    VDP_setPalette(0, pal_red);

    setVBlankCallback(vblankCB);
    JOY_setEventHandler(joyEventGame);
    while (!GLog_victory() && !GLog_gameover()) {

        old_vb_counter = vb_counter;
        GLog_updateGame();
        GRend_prepareRepaint();
        updateAudio();
        if (level_timer < 65000)level_timer++;
        while (old_vb_counter == vb_counter)asm("nop");

    }

    if (GLog_gameover()) {
        showGameover();
    }

    setVBlankCallback(0);
    JOY_setEventHandler(0);
}

void joyEventGame(u16 joy, u16 changed, u16 state) {


    if (GLog_gameover())return;
    if ((state & BUTTON_START) && (changed & BUTTON_START) && !gameover && level_timer > 180) {

        pause = pause ? 0 : 1;
        if (pause) {
            //startPlaySample(snd_pause, sizeof (snd_pause), 11000, AUDIO_PAN_CENTER, 9);
        }
    }
    if (pause)return;

    if (joy == JOY_1 && (state & (BUTTON_A | BUTTON_B | BUTTON_C)) && game_player[0].fire_timer == 0) {
        game_player[0].fire = 1;
        game_player[0].fire_timer = 1;
    }
    if (joy == JOY_2 && (state & (BUTTON_A | BUTTON_B | BUTTON_C)) && game_player[1].fire_timer == 0) {
        game_player[1].fire = 1;
        game_player[1].fire_timer = 1;
    }

    if (joy == JOY_1 && !(state & (BUTTON_A | BUTTON_B | BUTTON_C))) {
        game_player[0].fire_timer = 0;
    }
    if (joy == JOY_2 && !(state & (BUTTON_A | BUTTON_B | BUTTON_C))) {
        game_player[1].fire_timer = 0;
    }


}

void showGameover() {

    game_over_timer = 0;
    s16 word_x = MAP_W / 2 * 8 - 16;
    s16 word_y;
    u16 old_vb_counter = 0;


    while (game_over_timer < 256) {

        word_y = MAP_H * 8 - game_over_timer;
        if (word_y < MAP_H / 2 * 8)word_y = MAP_H / 2 * 8;
        drawSprite4x1(SPRITE_GAMEOVER, word_x, word_y);
        drawSprite4x1(SPRITE_GAMEOVER + 4, word_x, word_y + 8);
        old_vb_counter = vb_counter;
        GLog_updateGame();
        VDP_waitVSync();
        GRend_prepareRepaint();
        while (old_vb_counter == vb_counter)asm("nop");
        game_over_timer++;
    }
}

void updateAudio() {

    int speed = 0;
    if (GLog_gameover() || pause) {
        return;
    }
    if (game_player[0].hitpoint || game_player[1].hitpoint != 0)speed = 1;

    if (game_player[0].hitpoint && game_player[0].speed != 0) speed = 2;
    if (game_player[1].hitpoint && game_player[1].speed != 0) speed = 2;
    /*
        if (!isPlayingSample()) {
            if (speed == 1)startPlaySample(snd_engine_1, sizeof (snd_engine_1), 11000, AUDIO_PAN_CENTER, 2);
            if (speed == 2)startPlaySample(snd_engine_2, sizeof (snd_engine_2), 11000, AUDIO_PAN_CENTER, 2);
        }
     */
}
