

#include "genesis.h"
#include "gameover.h"
#include "map.h"
#include "resmap.h"
#include "menu.h"
#include "sprite.h"
#include "gamerender.h"
#include "game.h"
//#include "audio.h"

void showGameoverWord();
void setOrangeColor();
void drawTankIcons();


u8 num_buff[6];

void startGameOver() {

    u32 *save_ptr = (u32*) 0x200000;
    showScore();
    if (top_scor < game_player[0].scor)top_scor = game_player[0].scor;
    if (top_scor < game_player[1].scor)top_scor = game_player[1].scor;
    save_ptr[0] = top_scor >> 8;
	save_ptr[1] = top_scor ;
    save_ptr[2] = ~top_scor >> 8;
	save_ptr[3] = ~top_scor;
    //save_ptr[1] = game_player[0].scor > game_player[1].scor ? game_player[0].scor : game_player[1].scor;
    showGameoverWord();
}

void showScore() {


    u16 i;
    VDP_setPalette(0, palette_black);
    VDP_setPalette(1, palette_black);
    VDP_fillTileRect(APLAN, 0, 0, 0, vdp_plan_w, vdp_plan_h);


    if (menuGetSelectedItem() == ITEM_ONE_PLAYER) {
        setMap(APLAN, &maps_data[MAP_SCORE1 * MAP_LEN], 0);
    }
    else {
        setMap(APLAN, &maps_data[MAP_SCORE2 * MAP_LEN], 0);
    }

    setOrangeColor();
    drawTankIcons();
    VDP_setPalette(0, pal_red);
    VDP_setPalette(1, pal_red_text);
    VDP_setPalette(2, pal_orange_text);

    drawNum(top_scor, 160 / 8, 1);

    drawNum(selected_stage + 1, 128 / 8, 24 / 8);


    //game_player[0].scor += kills_1[0] * 100 + kills_1[1] * 200 + kills_1[2] * 300 + kills_1[3] * 400;
    drawNum(game_player[0].scor, 56 / 8, 56 / 8);
    drawNum(kills_1[0], 80 / 8, 80 / 8);
    drawNum(kills_1[1], 80 / 8, 104 / 8);
    drawNum(kills_1[2], 80 / 8, 128 / 8);
    drawNum(kills_1[3], 80 / 8, 152 / 8);
    drawNum(kills_1[0] * 100, 24 / 8, 80 / 8);
    drawNum(kills_1[1] * 200, 24 / 8, 104 / 8);
    drawNum(kills_1[2] * 300, 24 / 8, 128 / 8);
    drawNum(kills_1[3] * 400, 24 / 8, 152 / 8);
    drawNum(kills_1[0] + kills_1[1] + kills_1[2] + kills_1[3], 80 / 8, 168 / 8);

    if (menuGetSelectedItem() == ITEM_TWO_PLAYER) {

        //game_player[1].scor += kills_2[0] * 100 + kills_2[1] * 200 + kills_2[2] * 300 + kills_2[3] * 400;
        drawNum(game_player[1].scor, 200 / 8, 56 / 8);
        drawNum(kills_2[0] * 100, 168 / 8, 80 / 8);
        drawNum(kills_2[1] * 200, 168 / 8, 104 / 8);
        drawNum(kills_2[2] * 300, 168 / 8, 128 / 8);
        drawNum(kills_2[3] * 400, 168 / 8, 152 / 8);
        drawNum(kills_2[0], 128 / 8, 80 / 8);
        drawNum(kills_2[1], 128 / 8, 104 / 8);
        drawNum(kills_2[2], 128 / 8, 128 / 8);
        drawNum(kills_2[3], 128 / 8, 152 / 8);
        drawNum(kills_2[0] + kills_2[1] + kills_2[2] + kills_2[3], 128 / 8, 168 / 8);
    }


    sleepFrames(64);
    u16 joy;
    for (i = 0; i < 512; i++) {
        joy = JOY_readJoypad(JOY_1);
        joy |= JOY_readJoypad(JOY_2);
        if ((joy && BUTTON_START))break;
        VDP_waitVSync();
    }
}

void showGameoverWord() {

    VDP_setPalette(0, palette_black);
    VDP_fillTileRect(APLAN, 0, 0, 0, vdp_plan_w, vdp_plan_h);
    setMap(APLAN, &maps_data[MAP_GAMEOVER * MAP_LEN], 0);
    VDP_resetSprites();
    VDP_updateSprites();
    VDP_setPalette(0, pal_red);
//    startPlaySample(snd_gameover, sizeof (snd_gameover), 10000, AUDIO_PAN_CENTER, 9);
    sleepFrames(128);
}

void setOrangeColor() {

    u16 i;
    u16 tile;
    for (i = 0; i < MAP_W; i++) {

        tile = mapGetTile(i, 1);
        if (i < MAP_W >> 1) {
            tile |= TILE_ATTR(1, 0, 0, 0);
        }
        else {
            tile |= TILE_ATTR(2, 0, 0, 0);
        }
        mapSetTile(tile, i, 1);
        tile = mapGetTile(i, 5);
        tile |= TILE_ATTR(1, 0, 0, 0);
        mapSetTile(tile, i, 5);

        tile = mapGetTile(i, 7);
        tile |= TILE_ATTR(2, 0, 0, 0);
        mapSetTile(tile, i, 7);
    }

}

void drawTankIcons() {


    _tank t;
    t.god = 0;
    t.birth = 0;
    t.hitpoint = 1;
    t.type = 4;
    t.posx = 97;
    t.posy = 77;
    t.color = TANK_COLOR_GREY;
    t.speed = 0;
    t.bonus = 0;
    t.freeze = 0;
    t.rotate = 0;
    u16 i;
    updateSprite();
    for (i = 0; i < 4; i++) {
        drawTank(&t);
        t.type = t.type + 1;
        t.posy += 24;
    }
    GRend_repaint();
}

void drawNum(u32 num, u8 x, u8 y) {

    u8 len = 0;
    u16 i;
    u16 tile;

    num_buff[0] = num % 10;
    num_buff[1] = num % 100 / 10;
    num_buff[2] = num % 1000 / 100;
    num_buff[3] = num % 10000 / 1000;
    num_buff[4] = num % 100000 / 10000;
    num_buff[5] = num % 1000000 / 100000;

    for (i = 0; i < 6; i++) {
        if (num_buff[i] != 0)len = i + 1;
    }
    if (len < 1)len = 1;

    for (i = 0; i < len; i++) {
        tile = mapGetTile(x, y);
        tile &= 0xff00;
        tile |= '0' + num_buff[i];
        mapSetTile(tile, x, y);
        x -= 1;
    }
}
