#ifndef _VDP_DMA_H_
#define _VDP_DMA_H_


#define VDP_DMA_VRAM    0
#define VDP_DMA_CRAM    1
#define VDP_DMA_VSRAM   2


#define VDP_DoVRamDMA(from, to, len)            \
    VDP_DoDMA(VDP_DMA_VRAM, from, to, len)
#define VDP_DoDRamDMA(from, to, len)            \
    VDP_DoDMA(VDP_DMA_CRAM, from, to, len)
#define VDP_DoVSRamDMA(from, to, len)           \
    VDP_DoDMA(VDP_DMA_VSRAM, from, to, len)

#define VDP_DoVRamDMACopy(from, to, len)        \
    VDP_DoDMACopy(VDP_DMA_VRAM, from, to, len)
#define VDP_DoCRamDMACopy(from, to, len)        \
    VDP_DoDMACopy(VDP_DMA_CRAM, from, to, len)
#define VDP_DoVSRamDMACopy(from, to, len)       \
    VDP_DoDMACopy(VDP_DMA_VSRAM, from, to, len)


void VDP_DoDMA(u8 area, u32 from, u16 to, u16 len);
void VDP_DoDMAFill(u16 offset, u16 len, u16 value);
void VDP_DoDMACopy(u8 area, u16 from, u16 to, u16 len);


#endif // _VDP_DMA_H_
