#include "types.h"

#include "vdp.h"
#include "vdp_spr.h"


#include "tools.h"
#include "vdp_dma.h"
#include "vdp_tile.h"
#include "tools.h"



static u16 spriteNum;
u16 sprite_buff[320];
u16 *buff_ptr;

void VDP_resetSprites() {

    sprite_buff[0] = 0;
    sprite_buff[1] = 0;
    sprite_buff[2] = 0;
    sprite_buff[3] = 0;
    spriteNum = 1;
}

void VDP_setSpriteDirect(u16 index, u16 x, u16 y, u8 size, u16 tile_attr, u8 link) {

/*
    volatile u32 *plctrl;
    volatile u16 *pwdata;
*/
    u32 addr;

    VDP_setAutoInc(2);

    addr = SLIST + (index << 3);

    /* Point to vdp port */
  

    *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(addr);

    // y position
    *vdp_data_port_ptr16 = 0x80 + y;
    // size & link
    *vdp_data_port_ptr16 = (size << 8) | link;
    // tile attribut
    *vdp_data_port_ptr16 = tile_attr;
    // x position
    *vdp_data_port_ptr16 = 0X80 + x;
}

void VDP_setSpriteDirectP(u16 index, const _spritedef *sprite) {

/*
    volatile u32 *plctrl;
    volatile u16 *pwdata;
*/
    u32 addr;

    VDP_setAutoInc(2);

    addr = SLIST + (index << 3);

    /* Point to vdp port */


    *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(addr);

    // y position
    *vdp_data_port_ptr16 = 0x80 + sprite->posy;
    // size & link
    *vdp_data_port_ptr16= (sprite->size << 8) | sprite->link;
    // tile attribut
    *vdp_data_port_ptr16 = sprite->tile_attr;
    // x position
    *vdp_data_port_ptr16= 0X80 + sprite->posx;
}

void VDP_setSprite(u16 x, u16 y, u8 size, u16 tile_attr, u8 link) {

    *(buff_ptr++) = 0x80 + y;
    // size & link
    *(buff_ptr++) = (size << 8) | link;
    // tile attribut
    *(buff_ptr++) = tile_attr;
    // x position
    *(buff_ptr++) = 0X80 + x;
    spriteNum++;
}

void VDP_setSpriteP(const _spritedef *sprite) {

    *(buff_ptr++) = 0x80 + sprite->posy;
    // size & link
    *(buff_ptr++) = (sprite->size << 8) | sprite->link;
    // tile attribut
    *(buff_ptr++) = sprite->tile_attr;
    // x position
    *(buff_ptr++) = 0X80 + sprite->posx;
    spriteNum++;
}

void VDP_setSprites(const _spritedef *sprites, u16 num) {

    spriteNum += num;

    while (num--) {

        *(buff_ptr++) = 0x80 + sprites->posy;
        // size & link
        *(buff_ptr++) = (sprites->size << 8) | sprites->link;
        // tile attribut
        *(buff_ptr++) = sprites->tile_attr;
        // x position
        *(buff_ptr++) = 0X80 + sprites->posx;
        sprites += 1;
    }


}

void VDP_updateSprites() {

/*
    volatile u32 *plctrl;
    volatile u16 *pwdata;
*/


    if (spriteNum == 0) return;

    VDP_setAutoInc(2);

    /* Point to vdp port */

    *vdp_ctrl_port_ptr32 = GFX_WRITE_VRAM_ADDR(SLIST);

    {

        u16 i;

        buff_ptr = sprite_buff;
        i = spriteNum;
        while (i--) {
            // y position
            *vdp_data_port_ptr16 = *(buff_ptr++);
            // size & link
            *vdp_data_port_ptr16 = *(buff_ptr++);
            // tile attribut
            *vdp_data_port_ptr16 = *(buff_ptr++);
            // x position
            *vdp_data_port_ptr16 = *(buff_ptr++);

        }
    }

    // we won't upload unmodified sprite
    buff_ptr = sprite_buff;
    spriteNum = 0;
}

void VDP_updateSpritesDma() {

    VDP_DoDMA(VDP_DMA_VRAM, (u32) sprite_buff, SLIST, spriteNum << 3);

    buff_ptr = sprite_buff;
    spriteNum = 0;
}
