#ifndef _VDP_SPR_H_
#define _VDP_SPR_H_


#define SPRITE_SIZE(w, h)   ((((w) - 1) << 2) | ((h) - 1))

typedef struct {
    s16 posy;
    u8 size;
    u8 link;
    u16 tile_attr;
    s16 posx;
} _spritedef;


void VDP_resetSprites();

void VDP_setSprite(u16 x, u16 y, u8 size, u16 tile_attr, u8 link);
void VDP_setSpriteP(const _spritedef *sprite);
void VDP_setSpriteDirect(u16 index, u16 x, u16 y, u8 size, u16 tile_attr, u8 link);
void VDP_setSpriteDirectP(u16 index, const _spritedef *sprite);

void VDP_setSprites(const _spritedef *sprites, u16 num);

void VDP_updateSprites();
void VDP_updateSpritesDma();


#endif // _VDP_SPR_H_
