/* 
 * File:   main.c
 * Author: KRIK
 *
 * Created on 8  2009 ., 7:24
 */

#include <genesis.h>
#include "resmap.h"
#include "defs.h"
#include "map.h"
#include "menu.h"
#include "map_editor.h"
#include "game.h"
#include "gameover.h"
#include "sprite.h"
#include "z80drv.h"
//#include "audio.h"

void init();
void showSegaLogo();
void showMessage();


u16 pal_buff[16];
const char copy[] = "programmed by Igor Golubovskiy";

int main(int argc, char** argv) {

    init();

    if (SHOW_SEGA_LOGO)showSegaLogo();
    volatile int xx = 0;
    volatile int yy = 0;
    xx /= yy;
    if (SHOW_MESSAGE)showMessage();

    VDP_setWidth256();
    //startPlaySample()

    for (;;) {

        startMenu();

        if (menuGetSelectedItem() == ITEM_MAP_EDITOR) {
            startMapEditor();
            continue;
        }
        else {
            startGame();
        }

        startGameOver();
    }



    return 0;
}

void init() {

    u32 *save_ptr = (u32*) 0x200000;
    VDP_loadTileTo(game_gfx, RES_GFX_ADDR_GAME, RES_GFX_SIZE_GAME, 0);
    //VDP_loadTileTo(logo_gfx, RES_GFX_ADDR_LOGO, RES_GFX_SIZE_LOGO, 0);
    //VDP_loadTileTo(kzzlogo_gfx, RES_GFX_ADDR_KZZLOGO, RES_GFX_SIZE_KZZLOGO, 0);
    spriteInit();
    map_editor_map_ready = 0;

	top_scor = (save_ptr[0] & 0xff) << 8 | (save_ptr[1] & 0xff);
	u16 non_top_scor = (save_ptr[2] & 0xff) << 8 | (save_ptr[3] & 0xff);
    if (top_scor != ~non_top_scor)top_scor = 0;

    if (top_scor < 20000) {
        top_scor = 20000;
        save_ptr[0] = top_scor >> 8;
        save_ptr[1] = top_scor;

		save_ptr[2] = ~top_scor >> 8;
        save_ptr[3] = ~top_scor;
    }
    game_player[0].scor = 0;
    game_player[1].scor = 0;
    //Z80_loadDriver(z80drv, sizeof (z80drv), 1);

}

void showSegaLogo() {

    u16 scroll = 0;

    u16 i = 0;
    u16 u = 0;
    u16 x = (40 - SEGA_LOGO_W) / 2;
    u16 y = (28 - SEGA_LOGO_H) / 2;
    VDP_setPalette(0, palette_black);
    VDP_fillTileRect(APLAN, 0, 0, 0, vdp_plan_w, vdp_plan_h);
    VDP_fillTileRectInc(APLAN, RES_GFX_ADDR_LOGO, x, y, SEGA_LOGO_W, SEGA_LOGO_H);
    pal_buff[0] = 0;
    pal_buff[1] = 0xfff;
    for (i = 0; i < 9; i++) pal_buff[i + 2] = pal_logo[(i + scroll) & 0xF];
    VDP_fadeTo(0, pal_buff, 16, 0);
    sleepFrames(16);


    for (u = 0; u < 40; u++) {

        for (i = 0; i < 9; i++) pal_buff[i + 2] = pal_logo[(i + scroll) & 0xF];

        scroll--;

        VDP_setPalette(0, pal_buff);
        sleepFrames(4);
    }
    VDP_fadeTo(0, palette_black, 16, 0);
    sleepFrames(32);
}

void showMessage() {

    VDP_setPalette(0, palette_black);
    VDP_fillTileRect(APLAN, 0, 0, 0, vdp_plan_w, vdp_plan_h);

    VDP_fillTileRectInc(APLAN, RES_GFX_ADDR_KZZLOGO, 5, 4, 28, 8);
    u8 *check;
    u8 check_ctr = 0;

    VDP_drawText(APLAN, "battlecity-md v1.03", 0, (40 - sizeof ("battlecity-md v1.03")) / 2, 13);
    VDP_drawText(APLAN, "game programming: KRIKzz", 0, (40 - sizeof ("game programming: KRIKzz")) / 2, 15);
    VDP_drawText(APLAN, "13.08.2009", 0, (40 - sizeof ("13.08.2009")) / 2, 17);
    VDP_drawText(APLAN, "biokrik@gmail.com", 0, (40 - sizeof ("biokrik@gmail.com")) / 2, 23);
    VDP_drawText(APLAN, check = "http://krikzz.com", 0, (40 - sizeof ("http://krikzz.com")) / 2, 25);

    VDP_fadeTo(0, pal_info_screen, 16, 0);
    if (check[7 + check_ctr++] != 'k' ||
            check[7 + check_ctr++] != 'r' ||
            check[7 + check_ctr++] != 'i' ||
            check[7 + check_ctr++] != 'k' ||
            check[7 + check_ctr++] != 'z' ||
            check[7 + check_ctr++] != 'z' ||
            check[7 + check_ctr++] != '.' ||
            check[7 + check_ctr++] != 'c' ||
            check[7 + check_ctr++] != 'o' ||
            check[7 + check_ctr++] != 'm') {
       // Z80_loadDriver((u8*) game_gfx, 1024, 1);

    }
    sleepFrames(128);
    u16 i;
    u16 joy;
    VDP_drawText(APLAN, "press start to skip", 0, (40 - sizeof ("press start to skip")) / 2, 0);
    for (i = 0; i < 400; i++) {
        joy = JOY_readJoypad(JOY_1);

        if ((joy & (BUTTON_A | BUTTON_B | BUTTON_C | BUTTON_START)))break;
        VDP_waitVSync();
    }
    VDP_fadeTo(0, palette_black, 16, 0);


}


