
#include "genesis.h"
#include "map.h"
#include "resmap.h"



u16 current_map[MAP_LEN];
u16 map_plan;

void setMap(u16 plan, const u8 *map, u8 game_mode) {

    u16 i = 0;
    map_plan = plan;

    for (i = 0; i < MAP_LEN; i++) {
        current_map[i] = map[i];
        if (game_mode && current_map[i] == RES_TILE_GRASS) {
            current_map[i] |= TILE_ATTR(0, 1, 0, 0);
        }
    }
     
    if (game_mode) {

        mapSetTile(0, START_X_EN_A + 0, 0);
        mapSetTile(0, START_X_EN_A + 1, 0);
        mapSetTile(0, START_X_EN_A + 0, 1);
        mapSetTile(0, START_X_EN_A + 1, 1);

        mapSetTile(0, START_X_EN_B + 0, 0);
        mapSetTile(0, START_X_EN_B + 1, 0);
        mapSetTile(0, START_X_EN_B + 0, 1);
        mapSetTile(0, START_X_EN_B + 1, 1);

        mapSetTile(0, START_X_EN_C + 0, 0);
        mapSetTile(0, START_X_EN_C + 1, 0);
        mapSetTile(0, START_X_EN_C + 0, 1);
        mapSetTile(0, START_X_EN_C + 1, 1);

        mapSetTile(0, START_X_PL_A + 0, START_Y_PL_A + 0);
        mapSetTile(0, START_X_PL_A + 1, START_Y_PL_A + 0);
        mapSetTile(0, START_X_PL_A + 0, START_Y_PL_A + 1);
        mapSetTile(0, START_X_PL_A + 1, START_Y_PL_A + 1);

        mapSetTile(0, START_X_PL_B + 0, START_Y_PL_B + 0);
        mapSetTile(0, START_X_PL_B + 1, START_Y_PL_B + 0);
        mapSetTile(0, START_X_PL_B + 0, START_Y_PL_B + 1);
        mapSetTile(0, START_X_PL_B + 1, START_Y_PL_B + 1);

        mapSetTile(RES_TILE_STAFF + 0, START_X_ST + 0, START_Y_ST + 0);
        mapSetTile(RES_TILE_STAFF + 1, START_X_ST + 0, START_Y_ST + 1);
        mapSetTile(RES_TILE_STAFF + 2, START_X_ST + 1, START_Y_ST + 0);
        mapSetTile(RES_TILE_STAFF + 3, START_X_ST + 1, START_Y_ST + 1);
    }

    mapRepaint();
}

void mapSetTile(u16 val, u8 x, u8 y) {

    current_map[x + y * MAP_H] = val;
    VDP_setTile(map_plan, val, x + MAP_X, y + MAP_Y);
}

u16 mapGetTile(u16 x, u16 y) {

    return current_map[x + y * MAP_W];
}

void mapRepaint() {

    VDP_setTileRectDma(map_plan, current_map, MAP_X, MAP_Y, MAP_W, MAP_H);

}
