/*
 * File:   main.c
 * Author: krikzz
 *
 * Created on 21  2009 ., 13:02
 */



/*
 *
 */



#include "lib/segalib.h"
#include "globals_.h"
#include "tools_.h"
#include "select_file_.h"
#include "hard_.h"
#include "mmc_.h"

volatile u32 vb_counter;
u8 cy;
void play(Fat16Record *rec);
u8 loadImage(u32 *addr);

#define VIDEO_W 28
#define VIDEO_H 21
volatile u16 fps_frame_counter;
volatile u16 fps_timer;
volatile u16 fps;
u16 pal_buf[256];
u32 img_buff[VIDEO_W * VIDEO_H * 8];


u32 empty_cell[] = {

    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
    0x11111111,
};

int main() {


    VDP_init();
    VDP_loadFont(font_base, 0);
    VDP_setPaletteColor(0, 15, 0xfff);
    vb_counter = 0;
    cy = 1;
    fps_frame_counter = 0;
    fps = 0;



    VDP_drawText(APLAN, (u8 *) 0xff00f0, 0, 2, 2);
    VDP_drawText(APLAN, "cooool!", 0, 2, 3);
    for (;;) {
        // VDP_loadTileTo(empty_cell, 0, 1, 0);
        VDP_setPaletteColor(0, 0, 0x000);
        VDP_setPaletteColor(0, 15, 0xfff);
        VDP_setPaletteColor(0, 1, 0xaaa);
        VDP_setPaletteColor(0, 2, 0x444);
        VDP_setPaletteColor(1, 15, 0x444);
        VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
        VDP_setVerticalScroll(APLAN, 0, 0);
        Fat16Record *rec = selectFile(0);
        if (rec == 0)continue;
        play(rec);
    }


    return 0;
}

void play(Fat16Record *rec) {

    fps_timer = 0;
    u8 hide_buff = 0;
    u32 addr;
    u8 resp;
    VDP_loadTileTo(empty_cell, 1, 1, 0);
    VDP_setPaletteColor(2, 1, 0x000);
    VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
    VDP_fillTileRect(BPLAN, 1 | TILE_ATTR(2, 0, 0, 0), 0, 0, 40, 28);
    VDP_fillTileRect(BPLAN, 0 | TILE_ATTR(0, 0, 0, 0), (40 - VIDEO_W) / 2, (28 - VIDEO_H) / 2, VIDEO_W, VIDEO_H);
    VDP_fillTileRectInc(APLAN, 2 | TILE_ATTR(0, 0, 0, 0), (40 - VIDEO_W) / 2, (28 - VIDEO_H) / 2, VIDEO_W, VIDEO_H);
    VDP_fillTileRectInc(APLAN, (2 + VIDEO_W * VIDEO_H) | TILE_ATTR(1, 0, 0, 0), (40 - VIDEO_W) / 2, (28 - VIDEO_H) / 2 + 32, VIDEO_W, VIDEO_H);

    for (;;) {
        resp = fat16OpenFile(rec, &file);
        fat16SetNextReadSector(&file, &addr);
        for (;;) {
            //while (joy != 0);
            //while (joy == 0);
            if (file.pos >= file.record->size)break;
            file.pos += sizeof (img_buff) + sizeof (pal_buf);
            resp = loadImage(&addr);
            if (resp != 0) {
                VDP_fillTileRect(APLAN, 0, 0, 0, 40, 28);
                VDP_drawText(APLAN, "READ ERROR", 0, 1, 1);
                while (joy != 0);
                while (joy == 0);
                return;
            }
            hide_buff++;
            hide_buff &= 1;


            //VDP_waitVSync();
            VDP_DoDMA(VDP_DMA_CRAM, (u32) pal_buf, hide_buff * 32, 32);
            VDP_loadTileTo(img_buff, (2 + hide_buff * VIDEO_W * VIDEO_H), VIDEO_W * VIDEO_H, 1);
            VDP_setVerticalScroll(APLAN, 0, hide_buff * 256);
            fps_frame_counter++;
            //VDP_drawText(APLAN, "         ", 0, 1, hide_buff * 32 + 1);
            //drawNum("fps: ", (fps + 1), 0, 1, hide_buff * 32 + 1);
            if (joy == BUTTON_B)return;

        }
    }
}

u8 loadImage(u32 *addr) {

    u8 resp;
    u16 i; // = sizeof (img_buff);
    u8 *img = (u8 *) img_buff;

    resp = mmcRdBlock(*addr, (u8 *) pal_buf);
    *addr += 512;
    if (resp != 0)return 1;

    for (i = 0; i < sizeof (img_buff); i += 512) {

        resp = mmcRdBlock(*addr, &img[i]);
        if (resp != 0)return 1;
        *addr += 512;
    }



    return 0;
}
#define RESET_KEY (BUTTON_A | BUTTON_B | BUTTON_C | BUTTON_START)
void vb() {
    timer++;
    joy = JOY_readJoypad(JOY_1);
    if ((joy & RESET_KEY) == RESET_KEY) {
        asm("move.l 0x0004,%a0");
        asm("jmp (%a0)");
    }
}

void hb() {



}

void in() {

    VDP_drawText(APLAN, "INT", 0, 2, 3 + cy++);

}
