/* 
 * File:   mmc.c
 * Author: KRIK
 *
 * Created on 8  2009 ., 3:00
 */
#include "lib/types.h"
#include "tools_.h"
#include "lib/vdp.h"
#include "hard_.h"
#include "mmc_.h"

u8 mmcInit() {

    u16 i;

    SS_OFF;
    SPI_HI_SPEED_OFF;
    for (i = 0; i < 20; i++) {
        SPI_BUSY;
        SPI_PORT = 0xff;
    }

    if (mmcCmd(0x40, 0) != 1) {
        return 1;
    }

    i = 0;

    while (mmcCmd(0x41, 0) != 0) {
        if (i++ == 65535) {
            return 2;
        }
    }

    SS_ON;
    SPI_PORT = 0xff;
    SPI_BUSY;

    SPI_HI_SPEED_ON;
    SS_OFF;

    return 0;
}

inline u8 mmcCmd(u8 cmd, u32 arg) {


    SPI_BUSY;
    SS_ON;
    SPI_PORT = 0xff;
    SPI_BUSY;
    SPI_PORT = cmd;
    SPI_BUSY;
    SPI_PORT = (arg >> 24);
    SPI_BUSY;
    SPI_PORT = (arg >> 16);
    SPI_BUSY;
    SPI_PORT = (arg >> 8);
    SPI_BUSY;
    SPI_PORT = 0;
    SPI_BUSY;
    SPI_PORT = 0x95;
    SPI_BUSY;
    SPI_PORT = 0xff;
    SPI_BUSY;
    SPI_PORT = 0xff;
    SPI_BUSY;
    SS_OFF;
    SPI_BUSY;
    return SPI_PORT & 0xff;
}

u8 mmcWrBlock(u32 mmc_addr, u8 *data_ptr) {


    u16 i;
    if (mmcCmd(0x58, mmc_addr) != 0) {
        return 1;
    }

    SS_ON;
    SPI_BUSY;
    SPI_PORT = 0xff;
    SPI_BUSY;
    SPI_PORT = 0xff;
    SPI_BUSY;
    SPI_PORT = 0xfe;


    for (i = 0; i < 512; i++) {
        SPI_BUSY;
        SPI_PORT = *data_ptr++;
    }

    SPI_BUSY;
    SPI_PORT = 0xFF;
    SPI_BUSY;
    SPI_PORT = 0xFF;
    SPI_BUSY;
    SPI_PORT = 0xFF;
    SPI_BUSY;

    if ((SPI_PORT & 0x1f) != 0x05) {
        SS_OFF;
        return 2;
    }

    i = 0;
    SPI_BUSY;
    SPI_PORT = 0xFF;
    for (;;) {
        SPI_BUSY;
        SPI_PORT = 0xFF;
        SPI_BUSY;
        if ((SPI_PORT & 0xFF) == 0xff)break;
        if (i++ == 65535) {
            SS_OFF;
            return 3;
        }
    }
    SS_OFF;
    return 0;
}
//u32 rd_addr;
u32 rd_stor;

inline u8 mmcCmdFast(u8 cmd, u32 arg) {


    SS_ON;
    SPI_PORT = 0xff;
    asm("nop");
    asm("nop");
    SPI_PORT = cmd;
    asm("nop");
    asm("nop");
    SPI_PORT = (arg >> 24);
    asm("nop");
    asm("nop");
    SPI_PORT = (arg >> 16);
    asm("nop");
    asm("nop");
    SPI_PORT = (arg >> 8);
    asm("nop");
    asm("nop");
    SPI_PORT = 0;
    asm("nop");
    asm("nop");
    SPI_PORT = 0x95;
    asm("nop");
    asm("nop");
    SPI_PORT = 0xff;
    asm("nop");
    asm("nop");
    SPI_PORT = 0xff;
    asm("nop");
    asm("nop");
    SS_OFF;
    asm("nop");
    asm("nop");
    return SPI_PORT & 0xff;
}

u8 mmcRdBlock(u32 mmc_addr, u8 *stor) {

    u16 i = 0;
    //u16 *stor16 = (u16 *) stor;
    //rd_stor = (u32) stor;

    if (mmcCmdFast(0x51, mmc_addr) != 0) {

        for (;;) {

            SPI_PORT = 0xff;
            asm("nop");
            asm("nop");


            if ((SPI_PORT & 0xff) == 0) {
                break;
            }

            if (i++ == 65535) {
                SS_OFF;
                return 1;
            }
        }
    }

    SS_ON;


    i = 0;

    for (;;) {


        SPI_PORT = 0xff;
        asm("nop");
        asm("nop");
        if ((SPI_PORT & 0xff) == 0xfe)break;

        if (i++ == 65535) {
            SS_OFF;
            return 2;
        }
    }

    CFGS(_SPI16);
    rd_stor = (u32) stor;
    asm("movem.l %d0-%d4/%a0-%a3, -(%sp)");
    asm("move.l rd_stor, %a0");
    asm("move.w #256, %d0");
    asm("move.w #1, %d3");
    asm("move.w #0x50, %d4");
    asm("move.l #0xA13000, %a1");
    asm("move.l #0xA13002, %a2");
    asm("move.l #0xaaa, %a3");

    asm("wr_loop2:");

    asm("move.w #0xffff, (%a1)");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    //asm("nop");
    asm("move.w (%a1), (%a0)+"); //write word2

    asm("move.w #0xffff, (%a1)");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    //asm("nop");
    asm("move.w (%a1), (%a0)+");

    asm("move.w #0xffff, (%a1)");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    //asm("nop");
    asm("move.w (%a1), (%a0)+"); //write word2

    asm("move.w #0xffff, (%a1)");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    asm("nop");
    //asm("nop");
    asm("move.w (%a1), (%a0)+");


    asm("subq.w  #4, %d0");
    asm("bne.s  wr_loop2");

    asm("movem.l (%sp)+, %d0-%d4/%a0-%a3");


    CFGC(_SPI16);


    SPI_PORT = 0xff;
    SPI_BUSY;
    SPI_PORT = 0xff;
    SPI_BUSY;
    SS_OFF;
    return 0;
}


